﻿using GameResources.Models.World;
using System.Collections.Generic;


namespace GameResources.Models.Game
{
    public class MapHistory
    {
        public List<MapHistoryEntry> VisitedMapCells { get; set; }


        public MapHistory()
        {
            this.VisitedMapCells = new List<MapHistoryEntry>();
        }


        public void AddMapCell(WorldMapCell worldMapCell)
        {
            bool found = HasVisitedCell(worldMapCell);

            if (found == false) VisitedMapCells.Add(new MapHistoryEntry(worldMapCell));
        }


        public bool HasVisitedCell(WorldMapCell worldMapCell)
        {
            bool found = false;

            for (int i = 0; i < VisitedMapCells.Count; i++)
            {
                MapHistoryEntry entry = VisitedMapCells[i];

                if(entry.WorldKey == worldMapCell.WorldKey)
                {
                    if(entry.WorldCellX == worldMapCell.WorldMapX)
                    {
                        if(entry.WorldCellY == worldMapCell.WorldMapY)
                        {
                            found = true;
                        }
                    }
                }
            }

            return found;
        }
    }
}
