﻿using GameResources.Models.Game;
using Microsoft.Xna.Framework;
using System;


namespace GameResources.Models.Samus
{
    public class PlayerAimState
    {
        public enum State
        {
            Nothing,
            Aim_Angle_Up,
            Aim_Angle_Down,
            Up,
            Down
        }


        public State Current { get; set; }


        public PlayerAimState()
        {
            this.Current = State.Nothing;
        }


        public void Update(InputMap inputMap, long ticks, PlayerMotionState motionState)
        {
            if (motionState.IsBall() == false)
            {
                if (Current == State.Nothing)
                {
                    if (inputMap.AngleUp) Current = State.Aim_Angle_Up;
                    else if (inputMap.AngleDown) Current = State.Aim_Angle_Down;
                    else if (inputMap.Up && motionState.IsRunning() == false) Current = State.Up;
                    else if (inputMap.Up && motionState.IsRunning()) Current = State.Aim_Angle_Up;
                    else if (inputMap.Down && motionState.IsJumping()) Current = State.Down;
                }
                else if (Current == State.Aim_Angle_Up)
                {
                    if (inputMap.Up && motionState.IsRunning() == false) Current = State.Up;
                    else if (inputMap.AngleUp == false && inputMap.Up == false) Current = State.Nothing;
                }
                else if (Current == State.Aim_Angle_Down)
                {
                    if (inputMap.AngleDown == false) Current = State.Nothing;
                }
                else if (Current == State.Up)
                {
                    if (inputMap.Up && motionState.IsRunning()) Current = State.Aim_Angle_Up;
                    else if (inputMap.Up == false) Current = State.Nothing;
                }
                else if (Current == State.Down)
                {
                    if (inputMap.Down == false) Current = State.Nothing;
                    else if (motionState.IsJumping() == false) Current = State.Nothing;
                }
            }
            else
            {
                Current = State.Nothing;
            }
        }


        public Point GetWeaponPoint(PlayerMotionState motionState)
        {
            if(motionState.IsBall())
            {
                return new Point(0, -8);
            }
            else if(this.Current == State.Nothing)
            {
                if(motionState.IsCrouching())
                {
                    if (motionState.IsFacingLeft()) return new Point(-30, -28);
                    else return new Point(30, -28);
                }
                else if (motionState.IsJumping())
                {
                    if (motionState.IsFacingLeft()) return new Point(-28, -46);
                    else return new Point(28, -46);
                }
                else
                {
                    if(motionState.IsFacingLeft()) return new Point(-30, -54);
                    else return new Point(30, -54);
                }
            }
            else if (this.Current == State.Down)
            {
                if (motionState.IsFacingLeft()) return new Point(-4, 8);
                else return new Point(8, 8);
            }
            else if (this.Current == State.Up)
            {
                if (motionState.IsFacingLeft()) return new Point(-8, -100);
                else return new Point(8, -100);    
            }
            else if (this.Current == State.Aim_Angle_Up)
            {
                if (motionState.IsCrouching())
                {
                    if (motionState.IsFacingLeft()) return new Point(-28, -65);
                    else return new Point(28, -65);
                }
                else
                {
                    if (motionState.IsFacingLeft()) return new Point(-36, -92);
                    else return new Point(36, -92);
                }
            }
            else if (this.Current == State.Aim_Angle_Down)
            {
                if (motionState.IsCrouching())
                {
                    if (motionState.IsFacingLeft()) return new Point(-28, -2);
                    else return new Point(28, -2);
                }
                else
                {
                    if (motionState.IsFacingLeft()) return new Point(-36, -20);
                    else return new Point(36, -20);
                }
            }

            return new Point(0, 0);
        }


        public Point GetAimDirection(PlayerMotionState motionState)
        {
            int dx = 0;
            int dy = 0;

            if (this.Current == State.Nothing && motionState.IsFacingLeft())
            {
                dx = -1;
                dy = 0;
            }
            else if (this.Current == State.Nothing && motionState.IsFacingRight())
            {
                dx = 1;
                dy = 0;
            }
            else if (this.Current == State.Up)
            {
                dx = 0;
                dy = -1;
            }
            else if (this.Current == State.Down)
            {
                dx = 0;
                dy = 1;
            }
            else if (this.Current == State.Aim_Angle_Down && motionState.IsFacingLeft())
            {
                dx = -1;
                dy = 1;
            }
            else if (this.Current == State.Aim_Angle_Down && motionState.IsFacingRight())
            {
                dx = 1;
                dy = 1;
            }
            else if (this.Current == State.Aim_Angle_Up && motionState.IsFacingLeft())
            {
                dx = -1;
                dy = -1;
            }
            else if (this.Current == State.Aim_Angle_Up && motionState.IsFacingRight())
            {
                dx = 1;
                dy = -1;
            }

            return new Point(dx, dy);
        }

    }
}
