﻿using GameResources.Repository;
using Microsoft.Xna.Framework.Graphics;
using System;
using System.Collections.Generic;


namespace GameResources.Models.Samus
{
    public class PlayerCharacterSet
    {
        public enum State  {
            Crouch_Left,
            Crouch_Right,
            Crouch_Left_Aim_Up_Angle,
            Crouch_Right_Aim_Up_Angle,
            Crouch_Left_Aim_Down_Angle,
            Crouch_Right_Aim_Down_Angle,
            Stand_Left,
            Stand_Right,
            Stand_Left_Aim_Up,
            Stand_Left_Aim_Up_Angle,
            Stand_Left_Aim_Down_Angle,
            Stand_Right_Aim_Up,
            Stand_Right_Aim_Up_Angle,
            Stand_Right_Aim_Down_Angle,
            Run_Left_1, Run_Left_2, Run_Left_3, Run_Left_4, Run_Left_5, Run_Left_6, Run_Left_7, Run_Left_8, Run_Left_9, Run_Left_10,
            Run_Left_Aim_Up_Angle_1, Run_Left_Aim_Up_Angle_2, Run_Left_Aim_Up_Angle_3, Run_Left_Aim_Up_Angle_4, Run_Left_Aim_Up_Angle_5, Run_Left_Aim_Up_Angle_6, Run_Left_Aim_Up_Angle_7, Run_Left_Aim_Up_Angle_8, Run_Left_Aim_Up_Angle_9, Run_Left_Aim_Up_Angle_10,
            Run_Left_Aim_Down_Angle_1, Run_Left_Aim_Down_Angle_2, Run_Left_Aim_Down_Angle_3, Run_Left_Aim_Down_Angle_4, Run_Left_Aim_Down_Angle_5, Run_Left_Aim_Down_Angle_6, Run_Left_Aim_Down_Angle_7, Run_Left_Aim_Down_Angle_8, Run_Left_Aim_Down_Angle_9, Run_Left_Aim_Down_Angle_10,
            Run_Right_1, Run_Right_2, Run_Right_3, Run_Right_4, Run_Right_5, Run_Right_6, Run_Right_7, Run_Right_8, Run_Right_9, Run_Right_10,
            Run_Right_Aim_Up_Angle_1, Run_Right_Aim_Up_Angle_2, Run_Right_Aim_Up_Angle_3, Run_Right_Aim_Up_Angle_4, Run_Right_Aim_Up_Angle_5, Run_Right_Aim_Up_Angle_6, Run_Right_Aim_Up_Angle_7, Run_Right_Aim_Up_Angle_8, Run_Right_Aim_Up_Angle_9, Run_Right_Aim_Up_Angle_10,
            Run_Right_Aim_Down_Angle_1, Run_Right_Aim_Down_Angle_2, Run_Right_Aim_Down_Angle_3, Run_Right_Aim_Down_Angle_4, Run_Right_Aim_Down_Angle_5, Run_Right_Aim_Down_Angle_6, Run_Right_Aim_Down_Angle_7, Run_Right_Aim_Down_Angle_8, Run_Right_Aim_Down_Angle_9, Run_Right_Aim_Down_Angle_10,
            Jump_Left,
            Jump_Right,
            Jump_Left_Aim_Down,
            Jump_Right_Aim_Down,
            Jump_Left_Aim_Up,
            Jump_Right_Aim_Up,
            Jump_Left_Aim_Down_Angle,
            Jump_Right_Aim_Down_Angle,
            Jump_Left_Aim_Up_Angle,
            Jump_Right_Aim_Up_Angle,
            Bomb_Left,
            Bomb_Right,
            Bomb_Rolling_Left_1, Bomb_Rolling_Left_2,
            Bomb_Rolling_Right_1, Bomb_Rolling_Right_2,
            SpaceJump_Left_1, SpaceJump_Left_2, SpaceJump_Left_3, SpaceJump_Left_4, SpaceJump_Left_5, SpaceJump_Left_6, SpaceJump_Left_7, SpaceJump_Left_8,
            SpaceJump_Right_1, SpaceJump_Right_2, SpaceJump_Right_3, SpaceJump_Right_4, SpaceJump_Right_5, SpaceJump_Right_6, SpaceJump_Right_7, SpaceJump_Right_8,
            ScrewAttack_Left_1, ScrewAttack_Left_2, ScrewAttack_Left_3, ScrewAttack_Left_4, ScrewAttack_Left_5, ScrewAttack_Left_6, ScrewAttack_Left_7, ScrewAttack_Left_8,
            ScrewAttack_Right_1, ScrewAttack_Right_2, ScrewAttack_Right_3, ScrewAttack_Right_4, ScrewAttack_Right_5, ScrewAttack_Right_6, ScrewAttack_Right_7, ScrewAttack_Right_8
        }


        public State CurrentState;

        private readonly IGameNamedContentRepository<Texture2D> textureRepository;
        private readonly IDictionary<State, Texture2D> textures;
        private readonly IDictionary<State, int> textureWidths;
        private readonly IDictionary<State, int> textureHeights;


        public PlayerCharacterSet(IGameNamedContentRepository<Texture2D> textureRepository)
        {
            this.textureRepository = textureRepository;
            this.textures = new Dictionary<State, Texture2D>();
            this.textureWidths = new Dictionary<State, int>();
            this.textureHeights = new Dictionary<State, int>();

            this.CurrentState = State.Stand_Left;

            LoadTextures();
        }


        private void LoadTextures()
        {
            LoadTexture(State.Crouch_Left, @"textures\player\crouch-left");
            LoadTexture(State.Crouch_Right, @"textures\player\crouch-right");
            LoadTexture(State.Crouch_Left_Aim_Up_Angle, @"textures\player\crouch-left-aim-up-angle");
            LoadTexture(State.Crouch_Right_Aim_Up_Angle, @"textures\player\crouch-right-aim-up-angle");
            LoadTexture(State.Crouch_Left_Aim_Down_Angle, @"textures\player\crouch-left-aim-down-angle");
            LoadTexture(State.Crouch_Right_Aim_Down_Angle, @"textures\player\crouch-right-aim-down-angle");

            LoadTexture(State.Stand_Left, @"textures\player\stand-left");
            LoadTexture(State.Stand_Right, @"textures\player\stand-right");

            LoadTexture(State.Stand_Left_Aim_Up, @"textures\player\stand-left-aim-up");
            LoadTexture(State.Stand_Right_Aim_Up, @"textures\player\stand-right-aim-up");
            LoadTexture(State.Stand_Left_Aim_Up_Angle, @"textures\player\stand-left-aim-up-angle");
            LoadTexture(State.Stand_Left_Aim_Down_Angle, @"textures\player\stand-left-aim-down-angle");
            LoadTexture(State.Stand_Right_Aim_Up_Angle, @"textures\player\stand-right-aim-up-angle");
            LoadTexture(State.Stand_Right_Aim_Down_Angle, @"textures\player\stand-right-aim-down-angle");

            LoadTexture(State.Run_Left_1, @"textures\player\running-left-1");
            LoadTexture(State.Run_Left_2, @"textures\player\running-left-2");
            LoadTexture(State.Run_Left_3, @"textures\player\running-left-3");
            LoadTexture(State.Run_Left_4, @"textures\player\running-left-4");
            LoadTexture(State.Run_Left_5, @"textures\player\running-left-5");
            LoadTexture(State.Run_Left_6, @"textures\player\running-left-6");
            LoadTexture(State.Run_Left_7, @"textures\player\running-left-7");
            LoadTexture(State.Run_Left_8, @"textures\player\running-left-8");
            LoadTexture(State.Run_Left_9, @"textures\player\running-left-9");
            LoadTexture(State.Run_Left_10, @"textures\player\running-left-10");

            LoadTexture(State.Run_Left_Aim_Up_Angle_1, @"textures\player\running-left-aim-up-angle-1");
            LoadTexture(State.Run_Left_Aim_Up_Angle_2, @"textures\player\running-left-aim-up-angle-2");
            LoadTexture(State.Run_Left_Aim_Up_Angle_3, @"textures\player\running-left-aim-up-angle-3");
            LoadTexture(State.Run_Left_Aim_Up_Angle_4, @"textures\player\running-left-aim-up-angle-4");
            LoadTexture(State.Run_Left_Aim_Up_Angle_5, @"textures\player\running-left-aim-up-angle-5");
            LoadTexture(State.Run_Left_Aim_Up_Angle_6, @"textures\player\running-left-aim-up-angle-6");
            LoadTexture(State.Run_Left_Aim_Up_Angle_7, @"textures\player\running-left-aim-up-angle-7");
            LoadTexture(State.Run_Left_Aim_Up_Angle_8, @"textures\player\running-left-aim-up-angle-8");
            LoadTexture(State.Run_Left_Aim_Up_Angle_9, @"textures\player\running-left-aim-up-angle-9");
            LoadTexture(State.Run_Left_Aim_Up_Angle_10, @"textures\player\running-left-aim-up-angle-10");

            LoadTexture(State.Run_Left_Aim_Down_Angle_1, @"textures\player\running-left-aim-down-angle-1");
            LoadTexture(State.Run_Left_Aim_Down_Angle_2, @"textures\player\running-left-aim-down-angle-2");
            LoadTexture(State.Run_Left_Aim_Down_Angle_3, @"textures\player\running-left-aim-down-angle-3");
            LoadTexture(State.Run_Left_Aim_Down_Angle_4, @"textures\player\running-left-aim-down-angle-4");
            LoadTexture(State.Run_Left_Aim_Down_Angle_5, @"textures\player\running-left-aim-down-angle-5");
            LoadTexture(State.Run_Left_Aim_Down_Angle_6, @"textures\player\running-left-aim-down-angle-6");
            LoadTexture(State.Run_Left_Aim_Down_Angle_7, @"textures\player\running-left-aim-down-angle-7");
            LoadTexture(State.Run_Left_Aim_Down_Angle_8, @"textures\player\running-left-aim-down-angle-8");
            LoadTexture(State.Run_Left_Aim_Down_Angle_9, @"textures\player\running-left-aim-down-angle-9");
            LoadTexture(State.Run_Left_Aim_Down_Angle_10, @"textures\player\running-left-aim-down-angle-10");

            LoadTexture(State.Run_Right_1, @"textures\player\running-right-1");
            LoadTexture(State.Run_Right_2, @"textures\player\running-right-2");
            LoadTexture(State.Run_Right_3, @"textures\player\running-right-3");
            LoadTexture(State.Run_Right_4, @"textures\player\running-right-4");
            LoadTexture(State.Run_Right_5, @"textures\player\running-right-5");
            LoadTexture(State.Run_Right_6, @"textures\player\running-right-6");
            LoadTexture(State.Run_Right_7, @"textures\player\running-right-7");
            LoadTexture(State.Run_Right_8, @"textures\player\running-right-8");
            LoadTexture(State.Run_Right_9, @"textures\player\running-right-9");
            LoadTexture(State.Run_Right_10, @"textures\player\running-right-10");

            LoadTexture(State.Run_Right_Aim_Up_Angle_1, @"textures\player\running-right-aim-up-angle-1");
            LoadTexture(State.Run_Right_Aim_Up_Angle_2, @"textures\player\running-right-aim-up-angle-2");
            LoadTexture(State.Run_Right_Aim_Up_Angle_3, @"textures\player\running-right-aim-up-angle-3");
            LoadTexture(State.Run_Right_Aim_Up_Angle_4, @"textures\player\running-right-aim-up-angle-4");
            LoadTexture(State.Run_Right_Aim_Up_Angle_5, @"textures\player\running-right-aim-up-angle-5");
            LoadTexture(State.Run_Right_Aim_Up_Angle_6, @"textures\player\running-right-aim-up-angle-6");
            LoadTexture(State.Run_Right_Aim_Up_Angle_7, @"textures\player\running-right-aim-up-angle-7");
            LoadTexture(State.Run_Right_Aim_Up_Angle_8, @"textures\player\running-right-aim-up-angle-8");
            LoadTexture(State.Run_Right_Aim_Up_Angle_9, @"textures\player\running-right-aim-up-angle-9");
            LoadTexture(State.Run_Right_Aim_Up_Angle_10, @"textures\player\running-right-aim-up-angle-10");

            LoadTexture(State.Run_Right_Aim_Down_Angle_1, @"textures\player\running-right-aim-down-angle-1");
            LoadTexture(State.Run_Right_Aim_Down_Angle_2, @"textures\player\running-right-aim-down-angle-2");
            LoadTexture(State.Run_Right_Aim_Down_Angle_3, @"textures\player\running-right-aim-down-angle-3");
            LoadTexture(State.Run_Right_Aim_Down_Angle_4, @"textures\player\running-right-aim-down-angle-4");
            LoadTexture(State.Run_Right_Aim_Down_Angle_5, @"textures\player\running-right-aim-down-angle-5");
            LoadTexture(State.Run_Right_Aim_Down_Angle_6, @"textures\player\running-right-aim-down-angle-6");
            LoadTexture(State.Run_Right_Aim_Down_Angle_7, @"textures\player\running-right-aim-down-angle-7");
            LoadTexture(State.Run_Right_Aim_Down_Angle_8, @"textures\player\running-right-aim-down-angle-8");
            LoadTexture(State.Run_Right_Aim_Down_Angle_9, @"textures\player\running-right-aim-down-angle-9");
            LoadTexture(State.Run_Right_Aim_Down_Angle_10, @"textures\player\running-right-aim-down-angle-10");

            LoadTexture(State.Jump_Left, @"textures\player\jump-left");
            LoadTexture(State.Jump_Right, @"textures\player\jump-right");
            LoadTexture(State.Jump_Left_Aim_Down, @"textures\player\jump-left-aim-down");
            LoadTexture(State.Jump_Left_Aim_Up, @"textures\player\jump-left-aim-up");
            LoadTexture(State.Jump_Left_Aim_Down_Angle, @"textures\player\jump-left-aim-down-angle");
            LoadTexture(State.Jump_Left_Aim_Up_Angle, @"textures\player\jump-left-aim-up-angle");
            LoadTexture(State.Jump_Right_Aim_Down, @"textures\player\jump-right-aim-down");
            LoadTexture(State.Jump_Right_Aim_Up, @"textures\player\jump-right-aim-up");
            LoadTexture(State.Jump_Right_Aim_Down_Angle, @"textures\player\jump-right-aim-down-angle"); 
            LoadTexture(State.Jump_Right_Aim_Up_Angle, @"textures\player\jump-right-aim-up-angle");

            LoadTexture(State.Bomb_Left, @"textures\player\bomb-left-1");
            LoadTexture(State.Bomb_Right, @"textures\player\bomb-right-1");
            LoadTexture(State.Bomb_Rolling_Left_1, @"textures\player\bomb-left-1");
            LoadTexture(State.Bomb_Rolling_Left_2, @"textures\player\bomb-left-2");
            LoadTexture(State.Bomb_Rolling_Right_1, @"textures\player\bomb-right-1");
            LoadTexture(State.Bomb_Rolling_Right_2, @"textures\player\bomb-right-2");

            LoadTexture(State.SpaceJump_Left_1, @"textures\player\spacejump-left-1");
            LoadTexture(State.SpaceJump_Left_2, @"textures\player\spacejump-left-2");
            LoadTexture(State.SpaceJump_Left_3, @"textures\player\spacejump-left-3");
            LoadTexture(State.SpaceJump_Left_4, @"textures\player\spacejump-left-4");
            LoadTexture(State.SpaceJump_Left_5, @"textures\player\spacejump-left-5");
            LoadTexture(State.SpaceJump_Left_6, @"textures\player\spacejump-left-6");
            LoadTexture(State.SpaceJump_Left_7, @"textures\player\spacejump-left-7");
            LoadTexture(State.SpaceJump_Left_8, @"textures\player\spacejump-left-8");
            LoadTexture(State.SpaceJump_Right_1, @"textures\player\spacejump-right-1");
            LoadTexture(State.SpaceJump_Right_2, @"textures\player\spacejump-right-2");
            LoadTexture(State.SpaceJump_Right_3, @"textures\player\spacejump-right-3");
            LoadTexture(State.SpaceJump_Right_4, @"textures\player\spacejump-right-4");
            LoadTexture(State.SpaceJump_Right_5, @"textures\player\spacejump-right-5");
            LoadTexture(State.SpaceJump_Right_6, @"textures\player\spacejump-right-6");
            LoadTexture(State.SpaceJump_Right_7, @"textures\player\spacejump-right-7");
            LoadTexture(State.SpaceJump_Right_8, @"textures\player\spacejump-right-8");

            LoadTexture(State.ScrewAttack_Left_1, @"textures\player\screwattack-left-1");
            LoadTexture(State.ScrewAttack_Left_2, @"textures\player\screwattack-left-2");
            LoadTexture(State.ScrewAttack_Left_3, @"textures\player\screwattack-left-3");
            LoadTexture(State.ScrewAttack_Left_4, @"textures\player\screwattack-left-4");
            LoadTexture(State.ScrewAttack_Left_5, @"textures\player\screwattack-left-5");
            LoadTexture(State.ScrewAttack_Left_6, @"textures\player\screwattack-left-6");
            LoadTexture(State.ScrewAttack_Left_7, @"textures\player\screwattack-left-7");
            LoadTexture(State.ScrewAttack_Left_8, @"textures\player\screwattack-left-8");
            LoadTexture(State.ScrewAttack_Right_1, @"textures\player\screwattack-right-1");
            LoadTexture(State.ScrewAttack_Right_2, @"textures\player\screwattack-right-2");
            LoadTexture(State.ScrewAttack_Right_3, @"textures\player\screwattack-right-3");
            LoadTexture(State.ScrewAttack_Right_4, @"textures\player\screwattack-right-4");
            LoadTexture(State.ScrewAttack_Right_5, @"textures\player\screwattack-right-5");
            LoadTexture(State.ScrewAttack_Right_6, @"textures\player\screwattack-right-6");
            LoadTexture(State.ScrewAttack_Right_7, @"textures\player\screwattack-right-7");
            LoadTexture(State.ScrewAttack_Right_8, @"textures\player\screwattack-right-8");
        }


        private void LoadTexture(State state, string name)
        {
            Texture2D texture = textureRepository.GetContentByName(name);
            int drawMultiplier = 2;

            this.textures.Add(state, texture);
            this.textureWidths.Add(state, texture.Width * drawMultiplier);
            this.textureHeights.Add(state, texture.Height * drawMultiplier);
        }


        public Texture2D GetCurrentTexture()
        {
            return this.textures[this.CurrentState];
        }


        public int GetCurrentTextureWidth()
        {
            return this.textureWidths[this.CurrentState];
        }


        public int GetCurrentTextureHeight()
        {
            return this.textureHeights[this.CurrentState];
        }


        public void UpdateFrame(PlayerMotionState motionState, PlayerAimState aimState, PlayerAttackState attackState, PlayerInventory inventory)
        {
            State currentState = this.CurrentState;
            State newState = this.CurrentState;

            if(motionState.IsBall())
            {
                if (motionState.Current == PlayerMotionState.State.Ball_Left) newState = State.Bomb_Left;
                else if (motionState.Current == PlayerMotionState.State.Ball_Right) newState = State.Bomb_Right;
                else if (motionState.Current == PlayerMotionState.State.Ball_Fall_Left) newState = State.Bomb_Left;
                else if (motionState.Current == PlayerMotionState.State.Ball_Jump_Left) newState = State.Bomb_Left;
                else if (motionState.Current == PlayerMotionState.State.Ball_Fall_Right) newState = State.Bomb_Right;
                else if (motionState.Current == PlayerMotionState.State.Ball_Jump_Right) newState = State.Bomb_Right;
                else newState = GetNextBombRollingState(motionState, currentState);
            }
            else if(aimState.Current == PlayerAimState.State.Nothing)
            {
                if (motionState.Current == PlayerMotionState.State.Stand_Left) newState = State.Stand_Left;
                else if (motionState.Current == PlayerMotionState.State.Stand_Right) newState = State.Stand_Right;
                else if (motionState.Current == PlayerMotionState.State.Fall_Left)
                {
                    if (inventory.HasScrewAttack) newState = GetNextScrewAttackState(motionState, currentState);
                    else if (inventory.HasSpaceJump) newState = GetNextSpaceJumpState(motionState, currentState);
                    else newState = State.Jump_Left;
                }
                else if (motionState.Current == PlayerMotionState.State.Fall_Right)
                {
                    if (inventory.HasScrewAttack) newState = GetNextScrewAttackState(motionState, currentState);
                    else if (inventory.HasSpaceJump) newState = GetNextSpaceJumpState(motionState, currentState);
                    else newState = State.Jump_Right;
                }
                else if (motionState.Current == PlayerMotionState.State.Jump_Left)
                {
                    if (inventory.HasScrewAttack) newState = GetNextScrewAttackState(motionState, currentState);
                    else if (inventory.HasSpaceJump) newState = GetNextSpaceJumpState(motionState, currentState);
                    else newState = State.Jump_Left;
                }
                else if (motionState.Current == PlayerMotionState.State.Jump_Right)
                {
                    if (inventory.HasScrewAttack) newState = GetNextScrewAttackState(motionState, currentState);
                    else if (inventory.HasSpaceJump) newState = GetNextSpaceJumpState(motionState, currentState);
                    else newState = State.Jump_Right;
                }
                else if (motionState.Current == PlayerMotionState.State.Crouch_Left) newState = State.Crouch_Left;
                else if (motionState.Current == PlayerMotionState.State.Crouch_Right) newState = State.Crouch_Right;
                else newState = GetNextRunningState(motionState, currentState);
            }
            else if (aimState.Current == PlayerAimState.State.Down)
            {
                if(motionState.IsJumping())
                {
                    if (inventory.HasScrewAttack) newState = GetNextScrewAttackState(motionState, currentState);
                    else if (inventory.HasSpaceJump) newState = GetNextSpaceJumpState(motionState, currentState);
                    else if (motionState.IsFacingLeft()) newState = State.Jump_Left_Aim_Down;
                    else newState = State.Jump_Right_Aim_Down;
                }
            }
            else if (aimState.Current == PlayerAimState.State.Up)
            {
                if(motionState.IsJumping())
                {
                    if (inventory.HasScrewAttack) newState = GetNextScrewAttackState(motionState, currentState);
                    else if (inventory.HasSpaceJump) newState = GetNextSpaceJumpState(motionState, currentState);
                    else if (motionState.IsFacingLeft()) newState = State.Jump_Left_Aim_Up;
                    else newState = State.Jump_Right_Aim_Up;
                }
                else
                {
                    if (motionState.IsFacingLeft()) newState = State.Stand_Left_Aim_Up;
                    else newState = State.Stand_Right_Aim_Up;
                }
            }
            else if (aimState.Current == PlayerAimState.State.Aim_Angle_Down)
            {
                if (motionState.IsRunning())
                {
                    newState = GetNextRunningAimDownAngleState(motionState, currentState);
                }
                else if (motionState.IsJumping())
                {
                    if (inventory.HasScrewAttack) newState = GetNextScrewAttackState(motionState, currentState);
                    else if (inventory.HasSpaceJump) newState = GetNextSpaceJumpState(motionState, currentState);
                    else if (motionState.IsFacingLeft()) newState = State.Jump_Left_Aim_Down_Angle;
                    else newState = State.Jump_Right_Aim_Down_Angle;
                }
                else if (motionState.IsCrouching())
                {
                    if (motionState.IsFacingLeft()) newState = State.Crouch_Left_Aim_Down_Angle;
                    else newState = State.Crouch_Right_Aim_Down_Angle;
                }
                else
                {
                    if (motionState.IsFacingLeft()) newState = State.Stand_Left_Aim_Down_Angle;
                    else newState = State.Stand_Right_Aim_Down_Angle;
                }
            }
            else if (aimState.Current == PlayerAimState.State.Aim_Angle_Up)
            {
                if (motionState.IsRunning())
                {
                    newState = GetNextRunningAimUpAngleState(motionState, currentState);
                }
                else if (motionState.IsJumping())
                {
                    if (inventory.HasScrewAttack) newState = GetNextScrewAttackState(motionState, currentState);
                    else if (inventory.HasSpaceJump) newState = GetNextSpaceJumpState(motionState, currentState);
                    else if (motionState.IsFacingLeft()) newState = State.Jump_Left_Aim_Up_Angle;
                    else newState = State.Jump_Right_Aim_Up_Angle;
                }
                else if (motionState.IsCrouching())
                {
                    if (motionState.IsFacingLeft()) newState = State.Crouch_Left_Aim_Up_Angle;
                    else newState = State.Crouch_Right_Aim_Up_Angle;
                }
                else
                {
                    if (motionState.IsFacingLeft()) newState = State.Stand_Left_Aim_Up_Angle;
                    else newState = State.Stand_Right_Aim_Up_Angle;
                }
            }


            this.CurrentState = newState;
        }


        private State GetNextBombRollingState(PlayerMotionState motionState, State currentState)
        {
            State newState = currentState;

            if (motionState.IsFacingLeft())
            {
                if (currentState == State.Bomb_Rolling_Left_1) newState = State.Bomb_Rolling_Left_2;
                else newState = State.Bomb_Rolling_Left_1;
            }
            else
            {
                if (currentState == State.Bomb_Rolling_Right_1) newState = State.Bomb_Rolling_Right_2;
                else newState = State.Bomb_Rolling_Right_1;
            }

            return newState;
        }


        private State GetNextSpaceJumpState(PlayerMotionState motionState, State currentState)
        {
            State newState = currentState;

            if(motionState.IsFacingLeft()) 
            {
                if (currentState == State.SpaceJump_Left_1) newState = State.SpaceJump_Left_2;
                else if (currentState == State.SpaceJump_Left_2) newState = State.SpaceJump_Left_3;
                else if (currentState == State.SpaceJump_Left_3) newState = State.SpaceJump_Left_4;
                else if (currentState == State.SpaceJump_Left_4) newState = State.SpaceJump_Left_5;
                else if (currentState == State.SpaceJump_Left_5) newState = State.SpaceJump_Left_6;
                else if (currentState == State.SpaceJump_Left_6) newState = State.SpaceJump_Left_7;
                else if (currentState == State.SpaceJump_Left_7) newState = State.SpaceJump_Left_8;
                else if (currentState == State.SpaceJump_Left_8) newState = State.SpaceJump_Left_1;
                else newState = State.SpaceJump_Left_1;
            }
            else
            {
                if (currentState == State.SpaceJump_Right_1) newState = State.SpaceJump_Right_2;
                else if (currentState == State.SpaceJump_Right_2) newState = State.SpaceJump_Right_3;
                else if (currentState == State.SpaceJump_Right_3) newState = State.SpaceJump_Right_4;
                else if (currentState == State.SpaceJump_Right_4) newState = State.SpaceJump_Right_5;
                else if (currentState == State.SpaceJump_Right_5) newState = State.SpaceJump_Right_6;
                else if (currentState == State.SpaceJump_Right_6) newState = State.SpaceJump_Right_7;
                else if (currentState == State.SpaceJump_Right_7) newState = State.SpaceJump_Right_8;
                else if (currentState == State.SpaceJump_Right_8) newState = State.SpaceJump_Right_1;
                else newState = State.SpaceJump_Right_1;
            }

            return newState;
        }


        private State GetNextScrewAttackState(PlayerMotionState motionState, State currentState)
        {
            State newState = currentState;

            if (motionState.IsFacingLeft())
            {
                if (currentState == State.ScrewAttack_Left_1) newState = State.ScrewAttack_Left_2;
                else if (currentState == State.ScrewAttack_Left_2) newState = State.ScrewAttack_Left_3;
                else if (currentState == State.ScrewAttack_Left_3) newState = State.ScrewAttack_Left_4;
                else if (currentState == State.ScrewAttack_Left_4) newState = State.ScrewAttack_Left_5;
                else if (currentState == State.ScrewAttack_Left_5) newState = State.ScrewAttack_Left_6;
                else if (currentState == State.ScrewAttack_Left_6) newState = State.ScrewAttack_Left_7;
                else if (currentState == State.ScrewAttack_Left_7) newState = State.ScrewAttack_Left_8;
                else if (currentState == State.ScrewAttack_Left_8) newState = State.ScrewAttack_Left_1;
                else newState = State.ScrewAttack_Left_1;
            }
            else
            {
                if (currentState == State.ScrewAttack_Right_1) newState = State.ScrewAttack_Right_2;
                else if (currentState == State.ScrewAttack_Right_2) newState = State.ScrewAttack_Right_3;
                else if (currentState == State.ScrewAttack_Right_3) newState = State.ScrewAttack_Right_4;
                else if (currentState == State.ScrewAttack_Right_4) newState = State.ScrewAttack_Right_5;
                else if (currentState == State.ScrewAttack_Right_5) newState = State.ScrewAttack_Right_6;
                else if (currentState == State.ScrewAttack_Right_6) newState = State.ScrewAttack_Right_7;
                else if (currentState == State.ScrewAttack_Right_7) newState = State.ScrewAttack_Right_8;
                else if (currentState == State.ScrewAttack_Right_8) newState = State.ScrewAttack_Right_1;
                else newState = State.ScrewAttack_Right_1;
            }

            return newState;
        }


        private State GetNextRunningAimDownAngleState(PlayerMotionState motionState, State currentState)
        {
            State newState = currentState;

            if (motionState.IsFacingLeft())
            {
                if (currentState == State.Run_Left_Aim_Down_Angle_1) newState = State.Run_Left_Aim_Down_Angle_2;
                else if (currentState == State.Run_Left_Aim_Down_Angle_2) newState = State.Run_Left_Aim_Down_Angle_3;
                else if (currentState == State.Run_Left_Aim_Down_Angle_3) newState = State.Run_Left_Aim_Down_Angle_4;
                else if (currentState == State.Run_Left_Aim_Down_Angle_4) newState = State.Run_Left_Aim_Down_Angle_5;
                else if (currentState == State.Run_Left_Aim_Down_Angle_5) newState = State.Run_Left_Aim_Down_Angle_6;
                else if (currentState == State.Run_Left_Aim_Down_Angle_6) newState = State.Run_Left_Aim_Down_Angle_7;
                else if (currentState == State.Run_Left_Aim_Down_Angle_7) newState = State.Run_Left_Aim_Down_Angle_8;
                else if (currentState == State.Run_Left_Aim_Down_Angle_8) newState = State.Run_Left_Aim_Down_Angle_9;
                else if (currentState == State.Run_Left_Aim_Down_Angle_9) newState = State.Run_Left_Aim_Down_Angle_10;
                else newState = State.Run_Left_Aim_Down_Angle_1;
            }
            else
            {
                if (currentState == State.Run_Right_Aim_Down_Angle_1) newState = State.Run_Right_Aim_Down_Angle_2;
                else if (currentState == State.Run_Right_Aim_Down_Angle_2) newState = State.Run_Right_Aim_Down_Angle_3;
                else if (currentState == State.Run_Right_Aim_Down_Angle_3) newState = State.Run_Right_Aim_Down_Angle_4;
                else if (currentState == State.Run_Right_Aim_Down_Angle_4) newState = State.Run_Right_Aim_Down_Angle_5;
                else if (currentState == State.Run_Right_Aim_Down_Angle_5) newState = State.Run_Right_Aim_Down_Angle_6;
                else if (currentState == State.Run_Right_Aim_Down_Angle_6) newState = State.Run_Right_Aim_Down_Angle_7;
                else if (currentState == State.Run_Right_Aim_Down_Angle_7) newState = State.Run_Right_Aim_Down_Angle_8;
                else if (currentState == State.Run_Right_Aim_Down_Angle_8) newState = State.Run_Right_Aim_Down_Angle_9;
                else if (currentState == State.Run_Right_Aim_Down_Angle_9) newState = State.Run_Right_Aim_Down_Angle_10;
                else newState = State.Run_Right_Aim_Down_Angle_1;
            }

            return newState;
        }


        private State GetNextRunningAimUpAngleState(PlayerMotionState motionState, State currentState)
        {
            State newState = currentState;

            if (motionState.IsFacingLeft())
            {
                if (currentState == State.Run_Left_Aim_Up_Angle_1) newState = State.Run_Left_Aim_Up_Angle_2;
                else if (currentState == State.Run_Left_Aim_Up_Angle_2) newState = State.Run_Left_Aim_Up_Angle_3;
                else if (currentState == State.Run_Left_Aim_Up_Angle_3) newState = State.Run_Left_Aim_Up_Angle_4;
                else if (currentState == State.Run_Left_Aim_Up_Angle_4) newState = State.Run_Left_Aim_Up_Angle_5;
                else if (currentState == State.Run_Left_Aim_Up_Angle_5) newState = State.Run_Left_Aim_Up_Angle_6;
                else if (currentState == State.Run_Left_Aim_Up_Angle_6) newState = State.Run_Left_Aim_Up_Angle_7;
                else if (currentState == State.Run_Left_Aim_Up_Angle_7) newState = State.Run_Left_Aim_Up_Angle_8;
                else if (currentState == State.Run_Left_Aim_Up_Angle_8) newState = State.Run_Left_Aim_Up_Angle_9;
                else if (currentState == State.Run_Left_Aim_Up_Angle_9) newState = State.Run_Left_Aim_Up_Angle_10;
                else newState = State.Run_Left_Aim_Up_Angle_1;
            }
            else
            {
                if (currentState == State.Run_Right_Aim_Up_Angle_1) newState = State.Run_Right_Aim_Up_Angle_2;
                else if (currentState == State.Run_Right_Aim_Up_Angle_2) newState = State.Run_Right_Aim_Up_Angle_3;
                else if (currentState == State.Run_Right_Aim_Up_Angle_3) newState = State.Run_Right_Aim_Up_Angle_4;
                else if (currentState == State.Run_Right_Aim_Up_Angle_4) newState = State.Run_Right_Aim_Up_Angle_5;
                else if (currentState == State.Run_Right_Aim_Up_Angle_5) newState = State.Run_Right_Aim_Up_Angle_6;
                else if (currentState == State.Run_Right_Aim_Up_Angle_6) newState = State.Run_Right_Aim_Up_Angle_7;
                else if (currentState == State.Run_Right_Aim_Up_Angle_7) newState = State.Run_Right_Aim_Up_Angle_8;
                else if (currentState == State.Run_Right_Aim_Up_Angle_8) newState = State.Run_Right_Aim_Up_Angle_9;
                else if (currentState == State.Run_Right_Aim_Up_Angle_9) newState = State.Run_Right_Aim_Up_Angle_10;
                else newState = State.Run_Right_Aim_Up_Angle_1;
            }

            return newState;
        }


        private State GetNextRunningState(PlayerMotionState motionState, State currentState)
        {
            State newState = currentState;

            if (motionState.IsFacingLeft()) {
                if (currentState == State.Run_Left_1) newState = State.Run_Left_2;
                else if (currentState == State.Run_Left_2) newState = State.Run_Left_3;
                else if (currentState == State.Run_Left_3) newState = State.Run_Left_4;
                else if (currentState == State.Run_Left_4) newState = State.Run_Left_5;
                else if (currentState == State.Run_Left_5) newState = State.Run_Left_6;
                else if (currentState == State.Run_Left_6) newState = State.Run_Left_7;
                else if (currentState == State.Run_Left_7) newState = State.Run_Left_8;
                else if (currentState == State.Run_Left_8) newState = State.Run_Left_9;
                else if (currentState == State.Run_Left_9) newState = State.Run_Left_10;
                else newState = State.Run_Left_1;
            }
            else {
                if (currentState == State.Run_Right_1) newState = State.Run_Right_2;
                else if (currentState == State.Run_Right_2) newState = State.Run_Right_3;
                else if (currentState == State.Run_Right_3) newState = State.Run_Right_4;
                else if (currentState == State.Run_Right_4) newState = State.Run_Right_5;
                else if (currentState == State.Run_Right_5) newState = State.Run_Right_6;
                else if (currentState == State.Run_Right_6) newState = State.Run_Right_7;
                else if (currentState == State.Run_Right_7) newState = State.Run_Right_8;
                else if (currentState == State.Run_Right_8) newState = State.Run_Right_9;
                else if (currentState == State.Run_Right_9) newState = State.Run_Right_10;
                else newState = State.Run_Right_1;
            }

            return newState;
        }

    }
}
