﻿namespace GameResources.Models.Samus
{
    public class PlayerInventory
    {
        public enum Weapons { Normal, Missile, SuperMissle, SuperBomb } 

        public int Missiles { get; set; }
        public int MissilesMax { get; set; }
        public int SuperMissiles { get; set; }
        public int SuperMissilesMax { get; set; }
        public int SuperBombs { get; set; }
        public int SuperBombsMax { get; set; }
        public Weapons SelectedWeapon { get; set; }

        public bool HasSuperJump { get; set; }
        public bool HasMorphBall { get; set; }
        public bool HasBombs { get; set; }
        public bool HasChargeBeam { get; set; }
        public bool HasVariaSuit { get; set; }
        public bool HasSpringBall { get; set; }
        public bool HasSpazerBeam { get; set; }
        public bool HasWaveBeam { get; set; }
        public bool HasPlasmaBeam { get; set; }
        public bool HasIceBeam { get; set; }
        public bool HasGravitySuit { get; set; }
        public bool HasSpaceJump { get; set; }
        public bool HasScrewAttack { get; set; }
        public bool HasSpeedBoost { get; set; }


        public PlayerInventory()
        {
            SelectedWeapon = Weapons.Normal;
            Missiles = 0;
            MissilesMax = 0;
            SuperMissiles = 0;
            SuperMissilesMax = 0;
            SuperBombs = 0;
            SuperBombsMax = 0;
            HasSuperJump = false;
            HasMorphBall = false;
            HasBombs = false;
            HasVariaSuit = false;
            HasSpringBall = false;
            HasSpazerBeam = false;
            HasWaveBeam = false;
            HasPlasmaBeam = false;
            HasIceBeam = false;
            HasGravitySuit = false;
            HasSpaceJump = false;
            HasScrewAttack = false;
            HasSpeedBoost = false;
        }


        public void ChangeSelectedWeapon()
        {
            if (SelectedWeapon == Weapons.Normal) SelectedWeapon = Weapons.Missile;
            else if (SelectedWeapon == Weapons.Missile) SelectedWeapon = Weapons.SuperMissle;
            else if (SelectedWeapon == Weapons.SuperMissle) SelectedWeapon = Weapons.SuperBomb;
            else SelectedWeapon = Weapons.Normal;
        }


        public void CheckForNoAmmo()
        {
            if(SelectedWeapon == Weapons.Missile)
            {
                if (Missiles == 0) SelectedWeapon = Weapons.SuperMissle;
            }

            if(SelectedWeapon == Weapons.SuperMissle)
            {
                if (SuperMissiles == 0) SelectedWeapon = Weapons.Normal;
            }

            if(SelectedWeapon == Weapons.SuperBomb)
            {
                if (SuperBombs == 0) SelectedWeapon = Weapons.Normal;
            }
        }

    }
}
