﻿using Microsoft.Xna.Framework.Graphics;
using System.Collections.Generic;


namespace GameResources.Models.World
{
    public class TileSet
    {
        public static int DRAW_SIZE = 32;
        public int Key { get; set; }
        public Texture2D Texture { get; set; }
        public bool Passable { get; set; }
        public IList<TileSet> AnimationSequence { get; private set; }
        private int activeFrame;


        public TileSet()
        {
            this.AnimationSequence = new List<TileSet>();
            this.activeFrame = 0;
        }


        public Texture2D GetActiveTexture()
        {
            if (AnimationSequence.Count == 0)
            {
                return this.Texture;
            }
            else
            {
                return this.AnimationSequence[activeFrame].Texture;
            }
        }


        public void Update()
        {
            if (AnimationSequence.Count == 0) return;

            activeFrame++;
            if (activeFrame >= AnimationSequence.Count) activeFrame = 0;
        }


    }
}
