﻿using GameResources.Manager;
using GameResources.Models.Game;
using GameResources.Models.Physics;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;
using RawResources.Models;


namespace GameResources.Models.World
{
    public class Victory : IMoveableObject
    {
        public WorldPosition Position { get; set; }
        public Motion Motion { get; set; }
        public bool IsPlayerOn { get; set; }
        private readonly Texture2D backgroundTexture;
        private readonly SpriteFont font;


        public Victory(VictoryDefinition definition, IGameContentManager gameContentManager)
        {
            this.Motion = new Motion();
            this.Position = new WorldPosition()
            {
                PositionX = definition.X * TileSet.DRAW_SIZE,
                PositionY = definition.Y * TileSet.DRAW_SIZE
            };

            this.IsPlayerOn = false;

            this.backgroundTexture = gameContentManager.TextureRepository.GetContentByName(@"textures\white");
            this.font = gameContentManager.FontRepository.GetContentByName(@"fonts\Normal");
        }



        public void Draw(SpriteBatch spriteBatch, long dx, long dy)
        {
            if (this.IsPlayerOn)
            {
                string text = "Press Up";
                int size = (int)font.MeasureString(text).X;

                Rectangle rect = new Rectangle((int)(this.Position.PositionX - dx - (size / 2) - 8), (int)(this.Position.PositionY - dy - 96 - 8), size + 8 + 8, 20 + 8 + 8);
                spriteBatch.Draw(backgroundTexture, rect, Color.Black);

                Vector2 position = new Vector2((int)(this.Position.PositionX - dx - (size / 2)), (int)(this.Position.PositionY - dy - 96));
                spriteBatch.DrawString(font, text, position, Color.White);
            }
        }


        public Rectangle GetCollisionAreaAtPosition(long x, long y)
        {
            return new Rectangle((int)x, (int)y, TileSet.DRAW_SIZE, TileSet.DRAW_SIZE);
        }


        public Rectangle GetCurrentCollisionArea()
        {
            return GetCollisionAreaAtPosition(Position.PositionX, Position.PositionY);
        }


        public void Update(GameState gameState, IGameContentManager gameContentManager, long ticks)
        {
            this.IsPlayerOn = (gameState.Player.GetCurrentCollisionArea().Intersects(this.GetCurrentCollisionArea()));
        }
    }
}