﻿using System.Text;


namespace RawResources.Models
{
    public class PlayerDefinition
    {
        public WorldPosition StartPosition { get; set; }
        public int Health { get; set; }


        public static string GetCsvTitle()
        {
            return "StartMap,StartCellX,StartCellY,StartTileX,StartTileY,Health";
        }


        public string ToCsvString()
        {
            StringBuilder line = new StringBuilder();

            line.Append(StartPosition.WorldMapKey);
            line.Append(',');
            line.Append(StartPosition.WorldCellX);
            line.Append(',');
            line.Append(StartPosition.WorldCellY);
            line.Append(',');
            line.Append(StartPosition.PositionX);
            line.Append(',');
            line.Append(StartPosition.PositionY);
            line.Append(',');
            line.Append(Health);

            return line.ToString();
        }


    }
}
