﻿using RawResources.Models;
using System;
using System.Collections.Generic;
using System.IO;


namespace RawResources.Repository
{
    public class FilePlayerRepository : IRawContentRepository<PlayerDefinition>
    {
        private IDictionary<int, PlayerDefinition> contentsByKey;
        private IList<int> keys;


        public FilePlayerRepository(string filename)
        {
            Load(filename);
        }


        public PlayerDefinition GetContent(int key)
        {
            PlayerDefinition content = null;

            if (this.contentsByKey.ContainsKey(key))
            {
                content = this.contentsByKey[key];
            }

            return content;
        }


        public IList<PlayerDefinition> GetListOfContent()
        {
            IList<PlayerDefinition> content = new List<PlayerDefinition>();
            IList<int> keys = GetKeys();

            foreach (int key in keys)
            {
                content.Add(contentsByKey[key]);
            }

            return content;
        }


        public void AddContent(PlayerDefinition content)
        {
            RemoveContent(0);

            this.contentsByKey.Add(0, content);
            this.keys.Add(0);
        }


        public void RemoveContent(int key)
        {
            if (this.contentsByKey.ContainsKey(key))
            {
                this.contentsByKey.Remove(key);
                this.keys.Remove(key);
            }
        }


        public IList<int> GetKeys()
        {
            return this.keys;
        }


        public void Load(string filename)
        {
            Stream stream = null;
            StreamReader reader = null;
            string line = null;
            string[] lineContents = null;

            this.contentsByKey = new Dictionary<int, PlayerDefinition>();
            this.keys = new List<int>();

            try
            {
                stream = File.OpenRead(filename);
                reader = new StreamReader(stream);
            }
            catch (Exception e)
            {
                Console.Error.WriteLine(e.Message);
                return;
            }

            //skip first line
            reader.ReadLine();

            while ((line = reader.ReadLine()) != null)
            {
                lineContents = line.Split(',');

                if (lineContents[0].Equals("") == false)
                {
                    LoadContent(lineContents);
                }
            }

            reader.Close();
        }


        private void LoadContent(string[] lineContents)
        {
            PlayerDefinition definition = new PlayerDefinition();

            definition.StartPosition = new WorldPosition()
            {
                WorldMapKey = Int32.Parse(lineContents[0]),
                WorldCellX = Int32.Parse(lineContents[1]),
                WorldCellY = Int32.Parse(lineContents[2]),
                PositionX = Int32.Parse(lineContents[3]),
                PositionY = Int32.Parse(lineContents[4])
            };
            definition.Health = Int32.Parse(lineContents[5]);
            
            this.contentsByKey.Add(0, definition);
            this.keys.Add(0);
        }


        public void Save(string filename)
        {
            StreamWriter writer = new StreamWriter(filename, false);

            writer.WriteLine(PlayerDefinition.GetCsvTitle());

            foreach (int key in this.keys)
            {
                PlayerDefinition player = this.contentsByKey[key];

                writer.WriteLine(player.ToCsvString());
            }

            writer.Close();
        }

    }
}
