﻿using GameResources.Models.World;
using Microsoft.Xna.Framework;
using RawResources.Models;


namespace UserInterface.Helper
{
    public class Camera
    {
        public WorldMapCell WorldMapCell { get; set; }
        public WorldPosition Position { get; set; }
        public Rectangle Resolution { get; set; }


        public Camera()
        {
            this.WorldMapCell = null;
            this.Position = null;
            this.Resolution = default;
        }


        public Rectangle GetDrawBounds()
        {
            int xc = WorldMapCell.GetMaxTileX();
            int yc = WorldMapCell.GetMaxTileY();

            int xmax = xc * TileSet.DRAW_SIZE;
            int ymax = yc * TileSet.DRAW_SIZE;

            if((xmax ==  Resolution.Width) && (ymax == Resolution.Height))
            {
                return new Rectangle(0, 0, xmax, ymax);
            }

            int x1 = (int)Position.PositionX - (Resolution.Width / 2);
            int y1 = (int)Position.PositionY - (Resolution.Height / 2);
            int x2 = x1 + Resolution.Width;
            int y2 = y1 + Resolution.Height;

            if(x2 > xmax)
            {
                x1 -= (x2 - xmax);
                x2 = xmax;
            }

            if(y2 > ymax)
            {
                y1 -= (y2 - ymax);
                y2 = ymax;
            }

            if(x1 < 0)
            {
                x2 -= x1;
                x1 = 0;
            }

            if (y1 < 0)
            {
                y2 -= y1;
                y1 = 0;
            }


            return new Rectangle(x1, y1, Resolution.Width, Resolution.Height);
        }


    }
}
