﻿using GameResources.Manager;
using GameResources.Models.Game;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Media;
using System;
using UserInterface.Control;


namespace UserInterface.Screen
{
    public class StoryScreen : IScreen
    {
        public ControlCollection Controls { get; }
        private readonly IScreenController screenController;

        private long lastMovementInput;
        private long lastActionInput;
        private long lastStoryUpdate;

        private String storyString;
        private int character;
        private SpriteFont storyFont;


        public StoryScreen(IScreenController screenController)
        {
            this.Controls = new ControlCollection();
            this.screenController = screenController;

            Init();
        }


        public void Draw(SpriteBatch spriteBatch)
        {
            for (int i = 0; i < this.Controls.Count; i++)
            {
                IControl control = this.Controls[i];
                control.Draw(spriteBatch);
            }

            string text = storyString.Substring(0, character);
            spriteBatch.DrawString(storyFont, text, new Vector2(40, 40), Color.White);
        }


        public void Update(long ticks)
        {
            InputMap inputMap = screenController.GetInputMap();

            lastMovementInput += ticks;
            lastActionInput += ticks;
            lastStoryUpdate += ticks;

            //keyboard
            if (lastMovementInput >= (TimeSpan.TicksPerSecond * 0.12))
            {
                if (inputMap.Up)
                {
                    this.Controls.SelectPrev();
                    lastMovementInput = 0;
                }
                else if (inputMap.Down)
                {
                    this.Controls.SelectNext();
                    lastMovementInput = 0;
                }
            }

            if (lastActionInput >= (TimeSpan.TicksPerSecond * 0.12))
            {
                if (inputMap.Jump)
                {
                    if (this.Controls.IndexOfSelected() != -1)
                    {
                        lastActionInput = 0;
                        screenController.LastKeyboardInputTicks = 0;

                        this.Controls[this.Controls.IndexOfSelected()].Press();
                    }
                }
            }

            //story 
            if(lastStoryUpdate >= (TimeSpan.TicksPerSecond * 0.05))
            {
                character++;

                if (character > storyString.Length) character = storyString.Length;

                lastStoryUpdate = 0;
            }

            //controls
            foreach (IControl control in this.Controls)
            {
                control.Update(ticks);
            }
        }


        public void ActivateScreen()
        {
            Song song = this.screenController.GameContentManager.SongRepository.GetContentByName(@"music\theme");

            if (MediaPlayer.State == MediaState.Playing)
            {
                MediaPlayer.Stop();
            }

            this.screenController.BackgroundMusic = song;
            MediaPlayer.IsRepeating = true;
            MediaPlayer.Play(song);

            lastMovementInput = screenController.LastKeyboardInputTicks;
            lastActionInput = screenController.LastKeyboardInputTicks;
        }


        private void Init()
        {
            IGameContentManager gameContentManager = this.screenController.GameContentManager;

            int buttonWidth = 220;
            int buttonHeight = 32;
            int screenWidth = screenController.Resolution.GameWidth;
            int screenHeight = screenController.Resolution.GameHeight;

            this.Controls.Add(new Button()
            {
                Text = "Start Game",
                Location = new Rectangle(screenWidth - buttonWidth - 40, screenHeight - buttonHeight - 40, buttonWidth, buttonHeight),
                TextureNormal = gameContentManager.TextureRepository.GetContentByName(@"textures\ui\button"),
                TextureSelected = gameContentManager.TextureRepository.GetContentByName(@"textures\ui\button-select"),
                TexturePressed = gameContentManager.TextureRepository.GetContentByName(@"textures\ui\button-press"),
                Font = gameContentManager.FontRepository.GetContentByName(@"fonts\Normal"),
                PressSound = gameContentManager.SoundEffectRepository.GetContentByName(@"soundeffects\Samus Land"),
                IsSelected = true,
            });
            ((Button)this.Controls[this.Controls.Count - 1]).OnClick += StartGame;

            this.storyFont = gameContentManager.FontRepository.GetContentByName(@"fonts\Normal");
            character = 0;
            //linelengt += "123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-123456789ABCDEFGHIJKLM";
            storyString = "";
            storyString += "AFTER A SUCCESSFUL MISSION ON ZEBES, I WAS ON MY WAY BACK\n\n";
            storyString += "TO GALACTIC CIVILIZATION WHEN MY ENGINES STARTED TO FAIL!\n\n";
            storyString += "I MUST HAVE BEEN HIT BY DEBRIS FROM ZEBES ON MY ESCAPE.\n\n";
            storyString += "I'M MAKING AN EMERGENCY LANDING ON THE FIRST PLANET I CAN\n\n";
            storyString += "FIND... PLANET TN-7385 LOOKS GOOD... ATMOSPHERE, LIFE, \n\n";
            storyString += "CHOZO RUINS; I SHOULD BE ABLE TO FIND SOMETHING HELPFUL.\n\n";
            storyString += "\n\n";
            storyString += "AT THE LAST MINUTE, I LOSE ALL POWER AND BAIL OUT...\n\n";
            storyString += "\n\n";
            storyString += "I MUST FIND A WAY OFF THIS PLANET AND GET HOME!";
        }


        private void StartGame(object sender)
        {
            this.screenController.ChangeScreen(ScreenType.Game);
        }

    }
}
