﻿using GameResources.Logic.Physics;
using GameResources.Models.Game;
using GameResources.Models.World;


namespace GameResources.Logic.EnemyMotion
{
    public class FastFlyingEnemyMotion : IEnemyMotion
    {
        private Enemy enemy;
        private int xDirection;


        public FastFlyingEnemyMotion(Enemy enemy)
        {
            this.enemy = enemy;
            this.xDirection = 1;
        }


        public void Do(long ticks, GameState gameState)
        {
            enemy.Motion.VelocityX = 6 * xDirection;

            PhysicsEngine physics = new PhysicsEngine(enemy, gameState.GetActiveWorldMapCell(), gameState, false);
            physics.IgnoreObjects.Add(gameState.Player);
            physics.Update();

            if(enemy.Motion.VelocityX == 0) xDirection = xDirection * -1;
        }

    }
}
