﻿using GameResources.Logic.Physics;
using GameResources.Models.Game;
using GameResources.Models.World;
using System;


namespace GameResources.Logic.EnemyMotion
{
    public class JumperEnemyMotion : IEnemyMotion
    {
        private Enemy enemy;

        private long jumpStart;
        private long jumpEnd;
        private bool isJumping;

        public JumperEnemyMotion(Enemy enemy)
        {
            this.enemy = enemy;

            isJumping = false;

            jumpStart = 0;
            jumpEnd = 0;
        }


        public void Do(long ticks, GameState gameState)
        {
            jumpStart += ticks;
            jumpEnd += ticks;
            

            if ((isJumping == false) && (jumpEnd > (TimeSpan.TicksPerSecond * 1)))
            {
                isJumping = true;
                jumpStart = 0;
            }
            else if ((isJumping) && (jumpStart > (TimeSpan.TicksPerSecond * 0.25)))
            {
                isJumping = false;
                jumpEnd = 0;
            }



            if (isJumping)
            {
                this.enemy.Motion.VelocityX = 0;
                this.enemy.Motion.VelocityY = -12;
            }
            else
            {
                this.enemy.Motion.VelocityX = 0;
                this.enemy.Motion.VelocityY += 1;

                if (this.enemy.Motion.VelocityY > 10) this.enemy.Motion.VelocityY = 10;
            }

            PhysicsEngine physics = new PhysicsEngine(enemy, gameState.GetActiveWorldMapCell(), gameState, false);
            physics.IgnoreObjects.Add(gameState.Player);
            physics.Update();
        }


    }
}
