﻿using GameResources.Manager;
using GameResources.Models.Characters;
using GameResources.Models.Game;
using GameResources.Models.Weapons;
using Microsoft.Xna.Framework;
using RawResources.Models;


namespace GameResources.Logic.Weapons
{
    public class SuperMissileShooter
    {
        private readonly GameState gameState;
        private readonly IGameContentManager gameContentManager;


        public SuperMissileShooter(GameState gameState, IGameContentManager gameContentManager)
        {
            this.gameState = gameState;
            this.gameContentManager = gameContentManager;
        }


        public void Do(IBattleObject caster, WorldPosition launchPosition, Point direction)
        {
            SuperMissileShot shot = new SuperMissileShot(gameState, gameContentManager, caster);
            int speed = 5;

            shot.Position = launchPosition.Copy();
            shot.Motion.VelocityX = direction.X * speed;
            shot.Motion.VelocityY = direction.Y * speed;

            gameState.ActiveWeaponSprites.Add(shot);

            gameContentManager.SoundEffectRepository.GetContentByName(@"soundeffects\Super Missile Shoot").Play();
        }

    }
}
