﻿using GameResources.Models.World;
using GameResources.Repository;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;
using System;
using System.Collections.Generic;


namespace GameResources.Models.Effects
{
    public class HeatedRoomEffect : IEffect
    {
        public bool IsExpired { get; set; }

        private readonly IGameNamedContentRepository<Texture2D> textureRepository;
        private long lastAnimiationTime;
        private readonly IList<Texture2D> textures;
        private int activeTexture;
        private readonly int width;
        private readonly int height;


        public HeatedRoomEffect(IGameNamedContentRepository<Texture2D> textureRepository, int width, int height)
        {
            this.width = width;
            this.height = height;

            this.textureRepository = textureRepository;
            this.activeTexture = 0;

            this.textures = new List<Texture2D>();
            this.textures.Add(textureRepository.GetContentByName(@"textures\effects\heat-1"));
            this.textures.Add(textureRepository.GetContentByName(@"textures\effects\heat-2"));
            this.textures.Add(textureRepository.GetContentByName(@"textures\effects\heat-3"));
            this.textures.Add(textureRepository.GetContentByName(@"textures\effects\heat-4"));
            this.textures.Add(textureRepository.GetContentByName(@"textures\effects\heat-5"));
            this.textures.Add(textureRepository.GetContentByName(@"textures\effects\heat-6"));
            this.textures.Add(textureRepository.GetContentByName(@"textures\effects\heat-7"));
            this.textures.Add(textureRepository.GetContentByName(@"textures\effects\heat-8"));

            lastAnimiationTime = 0;
        }


        public void Draw(SpriteBatch spriteBatch, long dx, long dy)
        {
            for(int x = 0; x < width; x += TileSet.DRAW_SIZE)
            {
                for(int y = 0; y < height; y += TileSet.DRAW_SIZE)
                {
                    Rectangle rect = new Rectangle(x, y, TileSet.DRAW_SIZE, TileSet.DRAW_SIZE);
                    spriteBatch.Draw(this.textures[activeTexture], rect, Color.White);
                }
            }
            
        }

        public void Update(long ticks)
        {
            lastAnimiationTime += ticks;

            if (lastAnimiationTime > (TimeSpan.TicksPerSecond * 0.25))
            {
                activeTexture++;
                if (activeTexture >= this.textures.Count) activeTexture = 0;

                lastAnimiationTime = 0;
            }
        }
    }
}
