﻿using GameResources.Repository;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Graphics;
using System;
using System.Collections.Generic;


namespace GameResources.Models.Effects
{
    public class SmallEnemyDeathEffect : IEffect
    {
        private readonly IGameNamedContentRepository<Texture2D> textureRepository;
        private readonly IGameNamedContentRepository<SoundEffect> soundEffectRepository;
        private readonly double x;
        private readonly double y;

        private int size;
        private long startTime;
        private long lastAnimiationTime;
        private readonly IList<Texture2D> textures;
        private int activeTexture;


        public bool IsExpired { get; set; }


        public SmallEnemyDeathEffect(IGameNamedContentRepository<Texture2D> textureRepository, IGameNamedContentRepository<SoundEffect> soundEffectRepository, double x, double y)
        {
            this.textureRepository = textureRepository;
            this.soundEffectRepository = soundEffectRepository;
            this.x = x;
            this.y = y;

            this.activeTexture = 0;
            this.size = 32;

            this.textures = new List<Texture2D>();
            this.textures.Add(textureRepository.GetContentByName(@"textures\effects\supermissile-explosion-1"));
            this.textures.Add(textureRepository.GetContentByName(@"textures\effects\supermissile-explosion-2"));
            this.textures.Add(textureRepository.GetContentByName(@"textures\effects\supermissile-explosion-3"));
            this.textures.Add(textureRepository.GetContentByName(@"textures\effects\supermissile-explosion-4"));
            this.textures.Add(textureRepository.GetContentByName(@"textures\effects\supermissile-explosion-5"));
            this.textures.Add(textureRepository.GetContentByName(@"textures\effects\supermissile-explosion-6"));

            startTime = 0;
            lastAnimiationTime = 0;
        }



        public void Draw(SpriteBatch spriteBatch, long dx, long dy)
        {
            Rectangle rect = new Rectangle((int)(x - dx - (size / 2)), (int)(y - dy - (size / 2)), size, size);

            spriteBatch.Draw(this.textures[activeTexture], rect, Color.White);
        }


        public void Update(long ticks)
        {
            startTime += ticks;
            lastAnimiationTime += ticks;

            if (lastAnimiationTime > (TimeSpan.TicksPerSecond * 0.05))
            {
                activeTexture++;

                lastAnimiationTime = 0;
            }

            if (startTime >= (TimeSpan.TicksPerSecond * 0.25))
            {
                this.IsExpired = true;
            }
        }


    }
}
