﻿using Microsoft.Xna.Framework;


namespace GameResources.Models.Physics
{
    public class Motion
    {
        public float VelocityX { get; set; }
        public float VelocityY { get; set; }
        public bool IsOnGround { get; set; }


        public Motion()
        {
            Reset();
        }


        public void Reset()
        {
            this.VelocityX = 0;
            this.VelocityY = 0;
            this.IsOnGround = false;
        }

        
        public Vector2 UnitVector
        {
            get
            {
                Vector2 v = new Vector2((float)VelocityX, (float)VelocityY);

                v.Normalize();

                return v;
            }
        }


    }
}
