﻿using System.Collections.Generic;


namespace GameResources.Models.World
{
    public class WorldMap
    {
        public int Key { get; set; }
        public string Name { get; set; }
        public IDictionary<int, IDictionary<int, WorldMapCell>> Cells { get; }

        private ICollection<int> xKeys;
        private IDictionary<int, ICollection<int>> yKeys;
        private IList<WorldMapCell> cellList;

        public WorldMap()
        {
            this.Cells = new Dictionary<int, IDictionary<int, WorldMapCell>>();
            this.cellList = new List<WorldMapCell>();

            RefreshKeys();
        }


        public void AddCell(WorldMapCell cell)
        {
            if (this.Cells.ContainsKey(cell.WorldMapX) == false) this.Cells.Add(cell.WorldMapX, new Dictionary<int, WorldMapCell>());

            this.Cells[cell.WorldMapX].Add(cell.WorldMapY, cell);
            this.cellList.Add(cell);

            RefreshKeys();
        }


        private void RefreshKeys()
        {
            this.xKeys = this.Cells.Keys;

            this.yKeys = new Dictionary<int, ICollection<int>>();
            foreach(int x in this.xKeys)
            {
                IDictionary<int, WorldMapCell> column = this.Cells[x];
                ICollection<int> yKeys = column.Keys;

                this.yKeys.Add(x, yKeys);
            }
        }


        public WorldMapCell GetCellAtLocation(int x, int y)
        {
            for(int i = 0; i < this.cellList.Count; i++)
            {
                WorldMapCell cell = this.cellList[i];

                if ((x >= cell.WorldMapX) && (x <= (cell.WorldMapX + cell.WorldMapWidth - 1)))
                {
                    if ((y >= cell.WorldMapY) && (y <= (cell.WorldMapY + cell.WorldMapHeight - 1)))
                    {
                        return cell;
                    }
                }
            }

            return null;
        }


        public int GetNumCellWidth()
        {
            int max = 0;

            for (int i = 0; i < this.cellList.Count; i++)
            {
                WorldMapCell cell = this.cellList[i];
                int m = cell.WorldMapX + cell.WorldMapWidth;

                if (m > max) max = m;
            }

            return max;
        }


        public int GetNumCellHeight()
        {
            int max = 0;

            for (int i = 0; i < this.cellList.Count; i++)
            {
                WorldMapCell cell = this.cellList[i];
                int m = cell.WorldMapY + cell.WorldMapHeight;

                if (m > max) max = m;
            }

            return max;
        }



    }
}
