﻿using GameResources.Models.World;
using RawResources.Models;
using RawResources.Repository;


namespace GameResources.Repository
{
    public class DirectDestructableBlockRepository : IGameContentRepository<DestructableBlock>
    {
        private IRawContentRepository<DestructableBlockDefinition> destructableBlockRepository;
        private IGameContentRepository<TileSet> tileSetRepository;


        public DirectDestructableBlockRepository(IRawContentRepository<DestructableBlockDefinition> destructableBlockRepository, IGameContentRepository<TileSet> tileSetRepository)
        {
            this.destructableBlockRepository = destructableBlockRepository;
            this.tileSetRepository = tileSetRepository;
        }


        public DestructableBlock GetContentByKey(int key)
        {
            DestructableBlockDefinition definition = this.destructableBlockRepository.GetContent(key);
            if (definition == null) return null;

            DestructableBlock block = new DestructableBlock()
            {
                Key = definition.Key,
                Name = definition.Name,
                TileSet = tileSetRepository.GetContentByKey(definition.TileSetKey),
                RevealTileSet = tileSetRepository.GetContentByKey(definition.RevealTileSetKey),
                DamageType = definition.DamageType,
                OnlyShowIfVariableIsFalse = definition.OnlyShowIfVariableIsFalse,
                SetVariableToTrueUponDestruction = definition.SetVariableToTrueUponDestruction
            };

            return block;
        }

    }
}
