﻿using GameResources.Models.Samus;
using GameResources.Models.World;
using Microsoft.Xna.Framework.Graphics;
using RawResources.Models;
using RawResources.Repository;


namespace GameResources.Repository
{
    public class DirectPlayerRepository : IGameContentRepository<Player>
    {
        private readonly IRawContentRepository<PlayerDefinition> definitionRepository;
        private readonly IGameNamedContentRepository<Texture2D> textureRepository;


        public DirectPlayerRepository(IRawContentRepository<PlayerDefinition> definitionRepository, IGameNamedContentRepository<Texture2D> textureRepository)
        {
            this.definitionRepository = definitionRepository;
            this.textureRepository = textureRepository;
        }


        public Player GetContentByKey(int key)
        {
            if (definitionRepository.GetKeys().Contains(key) == false) return null;

            PlayerDefinition definition = definitionRepository.GetContent(key);
            Player player = new Player()
            {
                Position = definition.StartPosition.Copy(),
                CharacterSet = new PlayerCharacterSet(textureRepository),
            };

            player.CharacterStats.Health = definition.Health;
            player.CharacterStats.MaximumHealth = definition.Health;

            player.Position.PositionX *= TileSet.DRAW_SIZE;
            player.Position.PositionY *= TileSet.DRAW_SIZE;
            player.Position.PositionX += (TileSet.DRAW_SIZE / 2);
            player.Position.PositionY += (TileSet.DRAW_SIZE - 1);

            return player;
        }


        

    }
}
