﻿using System.Text;


namespace RawResources.Models
{
    public class EnemyDefinition
    {
        public int Key { get; set; }
        public string Name { get; set; }
        public int TextureKey1 {get; set; }
        public int TextureKey2 { get; set; }
        public EnemyMotionType MotionType { get; set; }
        public bool IsScrewable { get; set; }
        public bool IsBombable { get; set; }
        public bool IsFreezeable { get; set; }
        public bool IsBoss { get; set; }
        public bool IsExplosive { get; set; }
        public bool IsImmediatelyFreezable { get; set; }
        public int Health { get; set; }
        public int Attack { get; set; }
        public string OnlyShowIfVariableIsFalse { get; set; }
        public string SetVariableToTrueUponDeath { get; set; }
        public bool CanShoot { get; set; }
        public int? EnemyKeyForShooting { get; set; }
        public double ShootSpeed { get; set; }
        public double ItemDropChance { get; set; }


        public override string ToString()
        {
            return this.Key + " - " + this.Name;
        }


        public static string GetCsvTitle()
        {
            return "Key,Name,TextureKey1,TextureKey2,MotionType,IsScrewable,Health,Attack,OnlyShowIfVariableIsFalse,SetVariableToTrueUponDeath,IsBombable,IsFreezeable,IsImmediatelyFreezable,IsBoss,IsExplosive,CanShoot,EnemyKeyForShooting,ShootSpeed,ItemDropChance";
        }


        public string ToCsvString()
        {
            StringBuilder line = new StringBuilder();

            line.Append(Key);
            line.Append(',');
            line.Append(Name);
            line.Append(',');
            line.Append(TextureKey1);
            line.Append(',');
            line.Append(TextureKey2);
            line.Append(',');
            line.Append(MotionType);
            line.Append(',');
            line.Append(IsScrewable);
            line.Append(',');
            line.Append(Health);
            line.Append(',');
            line.Append(Attack);
            line.Append(',');
            line.Append(OnlyShowIfVariableIsFalse);
            line.Append(',');
            line.Append(SetVariableToTrueUponDeath);
            line.Append(',');
            line.Append(IsBombable);
            line.Append(',');
            line.Append(IsFreezeable);
            line.Append(',');
            line.Append(IsImmediatelyFreezable);
            line.Append(',');
            line.Append(IsBoss);
            line.Append(',');
            line.Append(IsExplosive);
            line.Append(',');
            line.Append(CanShoot);
            line.Append(',');

            if (EnemyKeyForShooting == null) line.Append("");
            else line.Append(EnemyKeyForShooting);
            
            line.Append(',');
            line.Append(ShootSpeed);
            line.Append(',');
            line.Append(ItemDropChance);

            return line.ToString();
        }


    }
}
