﻿using System.IO;

namespace RawResources.Models
{
    public class RawResource
    {
        public int Key { get; set; }
        public string FilePath { get; set; }


        public bool Equals(RawResource obj)
        {
            return (this.Key == obj.Key);
        }

        public override string ToString()
        {
            return FilePath;
        }

        public static string GetCsvTitle()
        {
            return "Key,ResourcePath";
        }

        public string ToCsvString()
        {
            return Key.ToString() + "," + FilePath;
        }

        public string SystemFilePath
        {
            get
            {
                return this.FilePath.Replace('\\', Path.DirectorySeparatorChar);
            }
        }
    }
}
