﻿using RawResources.Models;
using System;
using System.Collections.Generic;
using System.IO;


namespace RawResources.Repository
{
    public class FileEnemyRepository : IRawContentRepository<EnemyDefinition>
    {
        private IDictionary<int, EnemyDefinition> contentsByKey;
        private IList<int> keys;


        public FileEnemyRepository(string filename)
        {
            Load(filename);
        }


        public EnemyDefinition GetContent(int key)
        {
            EnemyDefinition content = default;

            if (this.contentsByKey.ContainsKey(key))
            {
                content = this.contentsByKey[key];
            }

            return content;
        }


        public IList<EnemyDefinition> GetListOfContent()
        {
            IList<EnemyDefinition> content = new List<EnemyDefinition>();
            IList<int> keys = GetKeys();

            foreach (int key in keys)
            {
                content.Add(contentsByKey[key]);
            }

            return content;
        }


        public void AddContent(EnemyDefinition content)
        {
            int key = GetMaxKey() + 1;

            content.Key = key;

            this.contentsByKey.Add(key, content);
            this.keys.Add(key);
        }


        public void RemoveContent(int key)
        {
            if (this.contentsByKey.ContainsKey(key))
            {
                this.contentsByKey.Remove(key);
                this.keys.Remove(key);
            }
        }


        private int GetMaxKey()
        {
            int maxKey = -1;

            foreach (int key in this.keys)
            {
                if (maxKey < key) maxKey = key;
            }

            return maxKey;
        }


        public IList<int> GetKeys()
        {
            return this.keys;
        }


        public void Load(string filename)
        {
            Stream stream = null;
            StreamReader reader = null;
            string line = null;
            string[] lineContents = null;

            this.contentsByKey = new Dictionary<int, EnemyDefinition>();
            this.keys = new List<int>();

            try
            {
                stream = File.OpenRead(filename);
                reader = new StreamReader(stream);
            }
            catch (Exception e)
            {
                Console.Error.WriteLine(e.Message);
                return;
            }

            //skip first line
            reader.ReadLine();

            while ((line = reader.ReadLine()) != null)
            {
                lineContents = line.Split(',');

                if (lineContents[0].Equals("") == false)
                {
                    LoadContent(lineContents);
                }
            }

            reader.Close();
        }


        private void LoadContent(string[] lineContents)
        {
            EnemyDefinition definition = new EnemyDefinition();

            definition.Key = Int32.Parse(lineContents[0]);
            definition.Name = lineContents[1];
            definition.TextureKey1 = Int32.Parse(lineContents[2]);
            definition.TextureKey2 = Int32.Parse(lineContents[3]);
            
            definition.MotionType = (EnemyMotionType)Enum.Parse(typeof(EnemyMotionType), lineContents[4]);
            definition.IsScrewable = Boolean.Parse(lineContents[5]);
            definition.Health = Int32.Parse(lineContents[6]);
            definition.Attack = Int32.Parse(lineContents[7]);
            
            definition.OnlyShowIfVariableIsFalse = lineContents[8];
            definition.SetVariableToTrueUponDeath = lineContents[9];
            
            definition.IsBombable = Boolean.Parse(lineContents[10]);
            definition.IsFreezeable = Boolean.Parse(lineContents[11]);
            definition.IsImmediatelyFreezable = Boolean.Parse(lineContents[12]);
            definition.IsBoss = Boolean.Parse(lineContents[13]);
            definition.IsExplosive = Boolean.Parse(lineContents[14]);

            definition.CanShoot = Boolean.Parse(lineContents[15]);

            if (lineContents[16].Equals("") == false) definition.EnemyKeyForShooting = Int32.Parse(lineContents[16]);
            else definition.EnemyKeyForShooting = null;

            definition.ShootSpeed = Double.Parse(lineContents[17]);
            definition.ItemDropChance = Double.Parse(lineContents[18]);

            this.contentsByKey.Add(definition.Key, definition);
            this.keys.Add(definition.Key);
        }


        public void Save(string filename)
        {
            StreamWriter writer = new StreamWriter(filename, false);

            writer.WriteLine(EnemyDefinition.GetCsvTitle());

            foreach (int key in this.keys)
            {
                EnemyDefinition block = this.contentsByKey[key];

                writer.WriteLine(block.ToCsvString());
            }

            writer.Close();
        }

    }
}
