﻿#version 410 core

struct light
{
	vec3 position;
	vec3 color;
	float brightness;
};

in vec3 f_color;
in vec2 f_texturePoints;
in vec3 f_position;

out vec4 fragColor;

uniform vec3 ambientLight;
uniform sampler2D textureImage;
uniform bool usesLighting;
uniform light lights[16];
uniform int numLights;


void main()
{
	if(usesLighting)
	{
		vec3 finalColor = ambientLight;

		if (abs(fract(f_position.x)) >= 0.0001) 
		{
			finalColor += vec3(0.15, 0.15, 0.15);
		}

		for (int i = 0; i < numLights; i++)
		{
			float dist = abs(distance(lights[i].position, f_position));
			
			float percent = 1.0 - (dist / lights[i].brightness);

			vec3 lightColor = lights[i].color * max(percent,0);

			finalColor += lightColor;
		}			

		finalColor = min(finalColor, vec3(1.0));

		fragColor = vec4(finalColor, 1.0f) * texture(textureImage, f_texturePoints);
	}
	else
	{
		fragColor = vec4(f_color, 1.0f) * texture(textureImage, f_texturePoints);
	}

	if (fragColor.a == 0.0)
	{
		discard;
	}
}
