﻿using System;
using GameEngine.Graphics;
using GameEngine.Graphics.Models;
using System.Numerics;
using GameEngine.Input;

namespace FirstPersonShooter.Controls
{
	public class LabelControl : IControl
	{
        private readonly GraphicsDevice graphicsDevice;
        private QuadHelper quadHelper;
        private Vector2 upperLeftCorner;
        private Quad? quad;
        private readonly float depth;


        public LabelControl(MyGame game, Texture renderedText, Vector2 upperLeftCorner, float depth)
		{
            this.graphicsDevice = game.GraphicsDevice;
            this.quadHelper = new QuadHelper(game.GraphicsDevice);

            this.depth = depth;
            this.upperLeftCorner = upperLeftCorner;

            SetRenderedText(renderedText);
        }


        public void SetRenderedText(Texture renderedText)
        {
            float x1 = upperLeftCorner.X;
            float y1 = upperLeftCorner.Y - renderedText.Height;
            Vector2 v1 = new Vector2(x1, y1);

            float x2 = x1 + renderedText.Width;
            float y2 = y1 + renderedText.Height;
            Vector2 v2 = new Vector2(x2, y2);

            this.quad = quadHelper.MakeQuadForUIFromAbsolute(renderedText, v1, v2, depth);
        }


        public void Draw()
        {
            if (this.quad != null)
            {
                this.graphicsDevice.DrawQuadRelative(this.quad);
            }
        }


        public void Update(InputState inputState)
        {
            //nothing
        }

    }
}

