﻿using System;
using FirstPersonShooter.Models;
using RawResources;
using RawResources.Models.Items;

namespace FirstPersonShooter.Factories
{
	public class AmmoTypeFactory
	{
        private readonly IRawContentManager rawContentManager;


        public AmmoTypeFactory(IRawContentManager rawContentManager)
		{
            this.rawContentManager = rawContentManager;
        }


        public AmmoType? GetAmmoType(int ammoTypeKey)
        {
            AmmoTypeDefinition? ammoTypeDefinition = this.rawContentManager.AmmoTypeRepository.GetContent(ammoTypeKey);

            if (ammoTypeDefinition != null)
            {
                AmmoType ammoType = new AmmoType(ammoTypeDefinition);

                return ammoType;
            }
            else
            {
                return null;
            }
        }

	}
}

