﻿using FirstPersonShooter.Models;
using GameEngine.Audio;

namespace FirstPersonShooter.Logic.EnemyBehaviours
{
	public class ExplosiveBarrelBehaviour : EnemyBehaviour
    {
        public ExplosiveBarrelBehaviour() : base()
        {

        }


        protected override void Act(Enemy enemy, MyGame game, GameState gameState)
        {
            //do nothing
        }


        public override void Die(Enemy enemy, MyGame game, GameState gameState)
        {
            //Spawn Explosion
            if (game.EffectsFactory == null) return;
            if (gameState.ActiveLevel == null) return;

            Effect? effect = game.EffectsFactory.GetExplosionEffect(enemy.Position, enemy.Damage);

            if (effect != null)
            {
                gameState.ActiveLevel.Effects.Add(effect);
            }

            //Play Sound
            Sound? sound = game.SoundManager.GetSoundByName("sounds/explosion.wav");
            if (sound != null) sound.Play();
        }

    }
}

