﻿using System.Numerics;
using FirstPersonShooter.Models;
using GameEngine.Audio;
using RawResources.Models.Items;

namespace FirstPersonShooter.Logic.EnemyBehaviours
{
	public class MagicBallTurretEnemyBehaviour : EnemyBehaviour
    {
		private int shootTicks;
		private readonly int TICKS_BETWEEN_SHOTS = 25;

		
		public MagicBallTurretEnemyBehaviour() : base()
		{
			this.shootTicks = GetRandomTick(0, TICKS_BETWEEN_SHOTS / 3); 
        }


		protected override void Act(Enemy enemy, MyGame game, GameState gameState)
		{
            Player? player = gameState.Player;
            if (player == null) return;

            Shoot(enemy, player, game, gameState);
        }


        private void Shoot(Enemy enemy, Player player, MyGame game, GameState gameState)
		{
			//shoot timer countdown
            if (this.shootTicks < TICKS_BETWEEN_SHOTS) this.shootTicks++;

			//shoot if able
			if (this.shootTicks >= TICKS_BETWEEN_SHOTS)
			{
				Vector3 direction = GetDirectionToPlayer(enemy, player);
				Vector3 origin = enemy.GetShootingOrigin(direction);

				gameState.BulletLauncher.ShootWeapon(enemy, ShootingTypes.MagicBall_Accurate, enemy.Damage, origin, direction);

				Sound? sound = game.SoundManager.GetSoundByName("sounds/spell-cast.wav");
				if (sound != null) sound.Play();

				//reset shoot timer
                this.shootTicks = GetRandomTick(0, TICKS_BETWEEN_SHOTS / 3);
            }
		}

	}
}

