﻿using System.Numerics;
using FirstPersonShooter.Models;

namespace FirstPersonShooter.Logic
{
	public class LevelChanger
	{
        private readonly MyGame game;
        private readonly GameState gameState;


        public LevelChanger(MyGame game, GameState gameState)
        {
            this.game = game;
            this.gameState = gameState;
        }


        public void ChangeToLevel(int levelKey, Vector3? position)
        {
            if (this.game.LevelFactory == null) return;
            if (this.gameState.Player == null) return;

            //stop current music
            this.game.StopBackgroundMusic();

            //reset inventory (keys)
            this.gameState.Player.Inventory.HasBlueKey = false;
            this.gameState.Player.Inventory.HasGreenKey = false;
            this.gameState.Player.Inventory.HasRedKey = false;

            //get new level
            Level? level = this.game.LevelFactory.GetLevel(levelKey);
            this.gameState.ActiveLevel = level;

            //set starting position (map default if not provided)
            if(position != null)
            {
                this.gameState.Player.Position = position.Value;
            }
            else
            {
                this.gameState.Player.Position = level.StartPosition;
            }

            //change & play level music
            this.game.BackgroundMusic = level.BackgroundMusic;
            this.game.PlayBackgroundMusic();
        }


    }
}

