﻿using System;
using FirstPersonShooter.Factories;
using FirstPersonShooter.Models;
using RawResources.Models;
using RawResources.Models.Items;

namespace FirstPersonShooter.Logic
{
	public class PickupCollector
	{
		private readonly Player player;
		private readonly WeaponFactory weaponFactory;
		private readonly AmmoTypeFactory ammoTypeFactory;


        public PickupCollector(Player player, WeaponFactory weaponFactory, AmmoTypeFactory ammoTypeFactory)
		{
			this.player = player;
			this.weaponFactory = weaponFactory;
			this.ammoTypeFactory = ammoTypeFactory;
		}


		public bool Collect(Pickup pickup)
		{
			if(pickup.PickupType == PickupTypes.Ammo)
			{
				if (player.Inventory.IsAmmoAtMax(pickup.AmmoTypeKey)) return false;

				player.Inventory.AddAmmo(pickup.AmmoTypeKey, pickup.Amount);
			}
            else if (pickup.PickupType == PickupTypes.Weapon)
            {
				AddWeapon(pickup.WeaponKey);
            }
            else if (pickup.PickupType == PickupTypes.Health)
			{
				if (player.HealthStats.Health == player.HealthStats.MaxHealth) return false;

                player.HealthStats.AddHealth(pickup.Amount);
            }
			else if (pickup.PickupType == PickupTypes.Armor)
			{
                if (player.HealthStats.Armor == player.HealthStats.MaxArmor) return false;

                player.HealthStats.AddArmor(pickup.Amount);
			}
			else if (pickup.PickupType == PickupTypes.BlueKey)
			{
				player.Inventory.HasBlueKey = true;
			}
            else if (pickup.PickupType == PickupTypes.GreenKey)
            {
				player.Inventory.HasGreenKey = true;
            }
            else if (pickup.PickupType == PickupTypes.RedKey)
            {
				player.Inventory.HasRedKey = true;
            }

			return true;
        }


		private void AddWeapon(int weaponKey)
		{
            Weapon? weapon = weaponFactory.GetWeapon(weaponKey);

            if (weapon != null)
            {
				bool hasWeapon = player.Inventory.HasWeaponInSlot(weapon.InventorySlot);

                player.Inventory.AddWeapon(weapon);

				if (hasWeapon == false)
				{
					player.ActiveWeapon = weapon;
				}
            }
        }


	}
}

