﻿using FirstPersonShooter.Models;

namespace FirstPersonShooter.Logic
{
	public class TextPointReader
	{
		private readonly GameState gameState;


		public TextPointReader(GameState gameState)
		{
			this.gameState = gameState;
		}


		public bool AttemptToReadText(Cube searchArea)
		{
            TextPoint? textPoint = GetTextPointInArea(searchArea);

			if (textPoint != null)
			{
				this.gameState.NodeReader.ReadText(textPoint.Text);

				return true;
			}

            return false;
        }


		private TextPoint? GetTextPointInArea(Cube searchArea)
		{
            if (this.gameState.ActiveLevel == null) return null;

            Level level = this.gameState.ActiveLevel;

            foreach (TextPoint textPoint in level.TextPoints)
            {
                Cube pointCube = textPoint.GetCollisionCube();

                if (searchArea.Intersects(pointCube))
                {
                    return textPoint;
                }
            }

			return null;
        }


		public bool IsTextAvailableToRead(Cube searchArea)
		{
			TextPoint? textPoint = GetTextPointInArea(searchArea);

			return (textPoint != null);
		}

    }
}

