﻿using System;
namespace FirstPersonShooter.Models
{
	public class HealthStats
	{
		public int Health { get; private set; }
		public int MaxHealth { get; private set; }
		public int Armor { get; private set; }
		public int MaxArmor { get; private set; }


		public HealthStats()
		{
			this.Armor = 0;
			this.Health = 0;
			this.MaxArmor = 0;
			this.MaxHealth = 0;
		}


		public void SetHealth(int health)
		{
			this.Health = health;
		}


		public void SetArmor(int armor)
		{
			this.Armor = armor;
		}


		public void SetAll(int startingHealth, int maxHealth, int startingArmor, int maxArmor)
		{
            this.Health = startingHealth;
            this.MaxHealth = maxHealth;
            this.Armor = startingArmor;
            this.MaxArmor = maxArmor;
        }


        public void AddHealth(int h)
		{
			this.Health += h;

			if (this.Health > this.MaxHealth) this.Health = this.MaxHealth;
			else if (this.Health < 0) this.Health = 0;
		}


        public void AddArmor(int a)
        {
            this.Armor += a;

            if (this.Armor > this.MaxArmor) this.Armor = this.MaxArmor;
            else if (this.Armor < 0) this.Armor = 0;
        }


		public bool IsDead()
		{
			return (this.Health == 0);
		}


    }
}

