﻿using RawResources.Models.Resources;
using Silk.NET.OpenAL;
using Silk.NET.SDL;


namespace GameEngine.Audio
{
    public class Sound : IDisposable
    {
        public Sound(SoundDefinition soundDefinition, uint buffer, uint source)
        {
            this.Key = soundDefinition.Key;
            this.IsLooped = soundDefinition.IsLooped;
            this.buffer = buffer;

            this.sources = new List<uint>
            {
                source
            };

            this.currentSourceIndex = 0;
        }


        public int Key { get; private set; }
        public bool IsLooped { get; private set; }

        private uint buffer;
        private int currentSourceIndex;
        private List<uint> sources;


        public void Dispose()
        {
            for (int i = 0; i < sources.Count; i++)
            {
                uint source = sources[i];

                AL.GetApi().DeleteSource(source);
            }

            AL.GetApi().DeleteBuffer(this.buffer);
        }


        public void Play()
        {
            if (this.IsLooped)
            {
                AL.GetApi().SetSourceProperty(this.sources[this.currentSourceIndex], SourceBoolean.Looping, true);
            }
            else if (IsPlaying())
            {
                uint source = AL.GetApi().GenSource();
                AL.GetApi().SetSourceProperty(source, SourceInteger.Buffer, this.buffer);

                this.sources.Add(source);
                currentSourceIndex++;
            }

            AL.GetApi().SourcePlay(this.sources[this.currentSourceIndex]);
        }


        public void Stop()
        {
            AL.GetApi().SourceStop(this.sources[this.currentSourceIndex]);
        }


        public bool IsPlaying()
        {
            for (int i = 0; i < sources.Count; i++)
            {
                uint source = sources[i];

                int state;
                AL.GetApi().GetSourceProperty(source, GetSourceInteger.SourceState, out state);

                bool result = (state == (int)SourceState.Playing);

                if (result) return true;
            }

            return false;
        }


    }
}
