﻿namespace GameEngine.Graphics.Models
{
    public class Quads
    {
        private List<Quad> quads;

        public Quads() 
        { 
            this.quads = new List<Quad>();
        }


        public void Add(Quad quad)
        {
            this.quads.Add(quad);
        }


        public void Clear()
        {
            this.quads.Clear();
        }


        public int Count
        {
            get 
            {
                return this.quads.Count;
            }
        }


        public Texture Texture { get { return this.quads[0].Texture; } }
        public bool UsesLighting { get { return this.quads[0].UsesLighting; } }
        public IList<Light> Lights { get { return this.quads[0].Lights; } }


        public float[] Vertices
        {
            get
            {
                int num = this.quads.Count;
                int m = 18;
                float[] v = new float[num * m];

                for(int i = 0; i < num; i++)
                {
                    for(int j = 0; j < m; j++)
                    {
                        v[(i * m) + j] = this.quads[i].Vertices[j];
                    }
                }

                return v;
            }
        }


        public float[] ColorMask
        {
            get
            {
                int num = this.quads.Count;
                int m = 18;
                float[] c = new float[num * m];

                for (int i = 0; i < num; i++)
                {
                    for (int j = 0; j < m; j++)
                    {
                        c[(i*m) + j] = this.quads[i].ColorMask[j];
                    }
                }

                return c;
            }
        }


        public float[] TexturePoints
        {
            get
            {
                int num = this.quads.Count;
                int m = 12;
                float[] t = new float[num * m];

                for (int i = 0; i < num; i++)
                {
                    for (int j = 0; j < m; j++)
                    {
                        t[(i * m) + j] = this.quads[i].TexturePoints[j];
                    }
                }

                return t;
            }
        }


        public bool CanQuadBeIncluded(Quad quad)
        {
            if (this.quads.Count == 0) return true;

            if (this.Texture.Key != quad.Texture.Key) return false;
            if (this.UsesLighting != quad.UsesLighting) return false;
            if (this.Lights.Count != quad.Lights.Count) return false;

            for(int i = 0; i < this.Lights.Count; i++)
            {
                if (this.Lights[i] != quad.Lights[i]) return false;
            }
            

            return true;
        }

    }
}
