﻿#version 410 core

in vec3 v_vertices;
in vec3 v_color;
in vec2 v_texturePoints;

out vec3 f_color;
out vec2 f_texturePoints;
out vec3 f_position;

uniform mat4 model;
uniform mat4 view;
uniform mat4 projection;

void main()
{
    f_color = v_color;
    f_texturePoints = v_texturePoints;
    f_position = v_vertices;

    gl_Position =  projection * view * model * vec4(v_vertices, 1.0);
}
