﻿using System.Numerics;

namespace GameEngine.Input
{
    public struct InputState
    {
        public InputState()
        {
            CloseProgram = false;
            Menu = false;
            TurnLeft = false;
            TurnRight = false;
            StrafeLeft = false;
            StrafeRight = false;
            Up = false;
            Down = false;
            Reload = false;
            Jump = false;
            ResolutionChange = false;

            NextWeapon = false;
            PreviousWeapon = false;
            Weapon1 = false;
            Weapon2 = false;
            Weapon3 = false;
            Weapon4 = false;
            Weapon5 = false;
            Weapon6 = false;
            Weapon7 = false;
            Weapon8 = false;
            Weapon9 = false;

            Use = false;
            Shoot = false;
            MouseMovement = default;
            MousePosition = default;
        }

        public bool CloseProgram;
        public bool Menu;
        public bool TurnLeft;
        public bool TurnRight;
        public bool StrafeLeft;
        public bool StrafeRight;
        public bool Up;
        public bool Down;
        public bool Reload;
        public bool Jump;
        public bool ResolutionChange;
        public bool Use;

        public bool NextWeapon;
        public bool PreviousWeapon;
        public bool Weapon1;
        public bool Weapon2;
        public bool Weapon3;
        public bool Weapon4;
        public bool Weapon5;
        public bool Weapon6;
        public bool Weapon7;
        public bool Weapon8;
        public bool Weapon9;

        public bool Shoot;
        public Vector2 MouseMovement;
        public Vector2 MousePosition;

    }
}