﻿namespace GameEngine.Support
{
	public class PerformanceTimer
	{
		private Dictionary<string, double> times;
		private double total;
		private DateTime lastTime;

		public PerformanceTimer()
		{
			this.times = new Dictionary<string, double>();
			this.total = 0;
			this.lastTime = DateTime.Now;
		}


		public void Clear()
		{
			this.times = new Dictionary<string, double>();
			this.total = 0;
		}


		public void Start()
		{
            this.lastTime = DateTime.Now;
        }


		public void AddTime(string name)
		{
			if (this.times.ContainsKey(name) == false)
			{
				this.times.Add(name, 0);
			}

			DateTime now = DateTime.Now;
			double time = (now - lastTime).TotalMilliseconds;
			
			this.times[name] = this.times[name] + time;
			this.total += time;

			this.lastTime = now;
		}


		public void DisplayResults()
		{
			if (this.total == 0) return;

			System.Console.Clear();

			System.Console.WriteLine("----->");
			foreach(string name in this.times.Keys)
			{
                double percent = this.times[name] / this.total * 100.00;

				System.Console.WriteLine(name + " : " + percent.ToString("#,##0.0"));
			}
            System.Console.WriteLine("-----<");

			System.Console.WriteLine("TIME: " + total.ToString("#,##0.00"));
            System.Console.WriteLine("FPS:  " + (1 / total * 1000).ToString("#,##0.00"));
        }

	}
}

