﻿namespace RawResources.Models.Levels
{
	public class EnemyDefinition
	{
		public int Key { get; set; }
		public string Name { get; set; }
		public int Health { get; set; }
		public int TextureKey { get; set; }
		public int Width { get; set; }
		public int Height { get; set; }
        public int Depth { get; set; }
		public EnemyTypes EnemyType { get; set; }
		public int Damage { get; set; }
		public int PickupKey { get; set; }
		public float DropRate { get; set; }


        public EnemyDefinition()
		{
			this.Key = -1;
			this.Name = "";
			this.Height = 32;
			this.Width = 16;
			this.Depth = 16;
			this.TextureKey = -1;
			this.Damage = 0;
			this.EnemyType = EnemyTypes.Passive;
			this.PickupKey = -1;
			this.DropRate = 0;
		}


        public override string ToString()
        {
			return this.Name;
        }

    }
}

