﻿using System.Numerics;

namespace RawResources.Models.Levels
{
	public class LevelDefinition
	{
		public IList<LightDefinition> Lights { get; private set; }
		public IList<GeometryDefinition> Geometry { get; private set; }
		public IList<NodeDefinition> Nodes { get; set; }
		public int Key { get; set; }
		public string Name { get; set; }
		public LightDefinition AmbientLight { get; private set; }
		public int AmbientSoundKey { get; set; }
		public int SkyBoxTextureKey { get; set; }


		public LevelDefinition()
		{
			this.Lights = new List<LightDefinition>();
			this.Geometry = new List<GeometryDefinition>();
			this.Nodes = new List<NodeDefinition>();
			this.Key = -1;
			this.Name = string.Empty;
			this.AmbientLight = new LightDefinition()
			{
				Color = new Vector3(1)
			};
			this.AmbientSoundKey = -1;
			this.SkyBoxTextureKey = -1;
        }


        public override string ToString()
        {
			return this.Name;
        }


		public bool HasQuadsInGeometry()
		{
			int c = this.Geometry.Select(x => x.Quads).Count();

			return (c != 0);
		}


        public int GetNewLightKey()
        {
            int newKey = 0;
            if (this.Lights.Count != 0) newKey = this.Lights.Max(x => x.Key) + 1;

            return newKey;
        }


        public int GetNewNodeKey()
		{
            int newKey = 0;
            if (this.Nodes.Count != 0) newKey = this.Nodes.Max(x => x.Key) + 1;

			return newKey;
        }



    }
}

