﻿using System;
using System.Linq;
using System.Numerics;
using System.Text;

namespace RawResources.Models.Levels
{
	public class QuadDefinition
	{
		public IList<Vector3> Points { get; private set; }
		public IList<int> LightKeys { get; private set; }

		public QuadDefinition()
		{
			this.Points = new List<Vector3>();
			for(int i = 0; i < 4; i++)
			{
				this.Points.Add(new Vector3(0));
			}

			this.LightKeys = new List<int>();
		}


		public string LightKeysToString()
		{
			StringBuilder builder = new StringBuilder();

			for(int i = 0; i < this.LightKeys.Count;i++)
			{
				builder.Append(this.LightKeys[i].ToString());

				if(i != (this.LightKeys.Count - 1)) builder.Append(",");
			}

			return builder.ToString();
		}


		public void AddLightKeysFromString(string rawLightKeys)
		{
			if (rawLightKeys == "") return;

			string[] lightKeys = rawLightKeys.Split(',');
			
			IEnumerable<int> keys = lightKeys.Select<string,int>(i => int.Parse(i));

			this.LightKeys.Clear();
			foreach (int key in keys) this.LightKeys.Add(key);
		}


        public Vector3 Centroid
		{
			get
			{
				Vector3 p1 = this.Points[0];
                Vector3 p2 = this.Points[1];
                Vector3 p3 = this.Points[2];
                Vector3 p4 = this.Points[3];

                float x = (p1.X + p2.X + p3.X + p4.X) / 4.0f;
                float y = (p1.Y + p2.Y + p3.Y + p4.Y) / 4.0f;
                float z = (p1.Z + p2.Z + p3.Z + p4.Z) / 4.0f;

				return new Vector3(x, y, z);
            }
		}


        public bool IsXAxisEqual()
        {
            float p1 = this.Points[0].X;
            float p2 = this.Points[1].X;
            float p3 = this.Points[2].X;
            float p4 = this.Points[3].X;

            return ((p1 == p2) && (p2 == p3) && (p3 == p4));
        }


        public bool IsYAxisEqual()
        {
            float p1 = this.Points[0].Y;
            float p2 = this.Points[1].Y;
            float p3 = this.Points[2].Y;
            float p4 = this.Points[3].Y;

            return ((p1 == p2) && (p2 == p3) && (p3 == p4));
        }


        public bool IsZAxisEqual()
        {
            float p1 = this.Points[0].Z;
            float p2 = this.Points[1].Z;
            float p3 = this.Points[2].Z;
            float p4 = this.Points[3].Z;

            return ((p1 == p2) && (p2 == p3) && (p3 == p4));
        }


    }
}

