﻿using System;
using RawResources.Models;
using RawResources.Models.Items;

namespace RawResources.Repositories
{
	public class FileAmmoTypeRepository : IRawContentRepository<AmmoTypeDefinition>
    {
        private IDictionary<int, AmmoTypeDefinition> contentsByKey;
        private IList<int> keys;


        public FileAmmoTypeRepository(string filename)
        {
            this.contentsByKey = new Dictionary<int, AmmoTypeDefinition>();
            this.keys = new List<int>();

            Load(filename);
        }


        public AmmoTypeDefinition? GetContent(int key)
        {
            if (this.contentsByKey.ContainsKey(key))
            {
                return this.contentsByKey[key];
            }

            return null;
        }


        public void RemoveContent(int key)
        {
            if (this.contentsByKey.ContainsKey(key))
            {
                this.contentsByKey.Remove(key);
                this.keys.Remove(key);
            }
        }


        public void AddContent(AmmoTypeDefinition content)
        {
            int key = GetMaxKey() + 1;

            content.Key = key;

            this.contentsByKey.Add(key, content);
            this.keys.Add(key);
        }


        private int GetMaxKey()
        {
            int maxKey = -1;

            foreach (int key in this.keys)
            {
                if (maxKey < key) maxKey = key;
            }

            return maxKey;
        }


        public IEnumerable<AmmoTypeDefinition> GetAllContent()
        {
            IList<AmmoTypeDefinition> content = new List<AmmoTypeDefinition>();
            IEnumerable<int> keys = GetKeys();

            foreach (int key in keys)
            {
                content.Add(contentsByKey[key]);
            }

            return content;
        }


        public IEnumerable<int> GetKeys()
        {
            return this.keys;
        }


        public void Load(string filename)
        {
            Stream stream;
            StreamReader reader;
            string? line = null;
            string[] lineContents;

            try
            {
                stream = File.OpenRead(filename);
                reader = new StreamReader(stream);
            }
            catch (Exception e)
            {
                Console.Error.WriteLine(e.Message);
                return;
            }

            //skip first line
            reader.ReadLine();

            while ((line = reader.ReadLine()) != null)
            {
                lineContents = line.Split('|');

                LoadContent(lineContents);
            }

            reader.Close();
        }


        private void LoadContent(string[] lineContents)
        {
            if (lineContents[0].Equals("") == false)
            {
                AmmoTypeDefinition item = new AmmoTypeDefinition()
                {
                    Key = Int32.Parse(lineContents[0]),
                    Name = lineContents[1],
                    StartingAmount = Int32.Parse(lineContents[2]),
                    MaxAmount = Int32.Parse(lineContents[3]),
                    ShootingType = Enum.Parse<ShootingTypes>(lineContents[4]),
                };

                this.contentsByKey.Add(item.Key, item);
                this.keys.Add(item.Key);
            }
        }


        public void Save(string filename)
        {
            StreamWriter writer = new StreamWriter(filename, false);

            writer.WriteLine("Key|Name|StartingAmount|MaxAmount|ShootingType");

            foreach (int key in this.keys)
            {
                AmmoTypeDefinition definition = this.contentsByKey[key];

                writer.Write(definition.Key);
                writer.Write("|");
                writer.Write(definition.Name);
                writer.Write("|");
                writer.Write(definition.StartingAmount);
                writer.Write("|");
                writer.Write(definition.MaxAmount);
                writer.Write("|");
                writer.Write(definition.ShootingType);
                writer.WriteLine("");
            }

            writer.Close();
        }

    }
}

