﻿using System.Numerics;
using FirstPersonShooter.Models;

namespace Tests;

[TestClass]
public class CubeTests
{
    [TestMethod]
    public void Intersects()
    {
        Vector3 start = new Vector3(1248, 768, 432);
        Vector3 end = new Vector3(1117, 824, 432.5f);
        Cube cube = new Cube(new Vector3(1280, 736, 416), new Vector3(1344, 768, 448));

        bool result = cube.Intersects(start, end);

        Assert.AreEqual(false, result);
    }


    [TestMethod]
    public void Intersects2()
    {
        Vector3 start = new Vector3(1312, 896, 432);
        Vector3 end = new Vector3(1168.5f, 822, 432.5f);
        Cube cube = new Cube(new Vector3(1152, 896, 416), new Vector3(1216, 928, 448));

        bool result = cube.Intersects(start, end);

        Assert.AreEqual(false, result);
    }

    /*
    [TestMethod]
    public void IntersectsExact()
    {
        Vector3 start = new Vector3(1248, 768, 432);
        Vector3 end = new Vector3(1117, 824, 432.5f);
        Cube cube = new Cube(new Vector3(1280, 736, 416), new Vector3(1344, 768, 448));

        Vector3? a, b;
        bool result = cube.GetExactLineSegmentIntersection(start, end, out a, out b);

        Assert.AreEqual(false, result);
    }
    */
}
