﻿using System;
using GameEngine.Graphics;
using GameEngine.Graphics.Models;
using System.Numerics;
using GameEngine.Input;

namespace FirstPersonShooter.Controls
{
	public class MouseCursorControl : IControl
	{
        private readonly GraphicsDevice graphicsDevice;
        private readonly QuadHelper quadHelper;
        private Texture? texture;
        private Quad? quad;
        private Vector2 absolutePoint;
        private readonly float depth;

        private readonly float width = 32f;
        private readonly float height = 32f;


        public MouseCursorControl(MyGame game, string textureName, Vector2 absolutePoint, float depth) 
		{
            this.graphicsDevice = game.GraphicsDevice;
            this.quadHelper = new QuadHelper(game.GraphicsDevice);
            this.depth = depth;

            this.texture = game.TextureManager.GetTextureByName(textureName);
            this.absolutePoint = absolutePoint;

            this.quad = GetQuad();
        }


        public void Draw()
        {
            if (this.quad != null)
            {
                this.graphicsDevice.DrawQuadRelative(this.quad);
            }
        }


        public void Update(InputState inputState)
        {
            this.absolutePoint = inputState.MousePosition;

            this.quad = GetQuad();
        }


        private Quad? GetQuad()
        {
            if (texture == null) return null;

            Vector2 secondPoint = new Vector2(this.absolutePoint.X + width, this.absolutePoint.Y - height);
            Quad quad = quadHelper.MakeQuadForUIFromAbsolute(this.texture, this.absolutePoint, secondPoint, depth);

            return quad;
        }

    }
}

