﻿using System.Numerics;
using GameEngine.Graphics;
using GameEngine.Graphics.Models;

namespace FirstPersonShooter.Controls
{
	public class QuadHelper
	{
        private readonly GraphicsDevice graphicsDevice;
        public IList<Light> EmptyLightList { get; set; }


		public QuadHelper(GraphicsDevice graphicsDevice)
		{
            this.graphicsDevice = graphicsDevice;
            this.EmptyLightList = new List<Light>();
		}


        public Quad MakeQuadForUIFromRelative(Texture texture, Vector2 relative1, Vector2 relative2, float depth)
        {
            IList<Vector3> points = GetPointsForRelativeQuad(relative1, relative2, depth);

            Quad quad = new Quad(points, texture, this.EmptyLightList, false, false);

            return quad;
        }


        public Quad MakeQuadForUIFromAbsolute(Texture texture, Vector2 absolute1, Vector2 absolute2, float depth)
        {
            Vector2 relative1 = GetRelativeFromAbsolute(absolute1);
            Vector2 relative2 = GetRelativeFromAbsolute(absolute2);

            return MakeQuadForUIFromRelative(texture, relative1, relative2, depth);
        }


        private IList<Vector3> GetPointsForRelativeQuad(Vector2 p1, Vector2 p2, float depth)
        {
            List<Vector3> points = new List<Vector3>()
            {
                new Vector3(p1.X, p2.Y, depth),
                new Vector3(p2.X, p2.Y, depth),
                new Vector3(p1.X, p1.Y, depth),
                new Vector3(p2.X, p1.Y, depth)
            };

            return points;
        }


        private Vector2 GetRelativeFromAbsolute(Vector2 absolute)
        {
            return GetRelativeFromAbsolute(absolute.X, absolute.Y);
        }


        private Vector2 GetRelativeFromAbsolute(float x, float y)
        {
            int width = this.graphicsDevice.ScreenWidth;
            int height = this.graphicsDevice.ScreenHeight;

            float rx = ((x / width) * 2) - 1;
            float ry = ((y / height) * 2) - 1;

            return new Vector2(rx, ry);
        }

    }
}

