﻿using FirstPersonShooter.Models;
using System.Numerics;
using GameEngine.Graphics;
using RawResources;
using RawResources.Models.Levels;
using FirstPersonShooter.Logic.EnemyBehaviours;


namespace FirstPersonShooter.Factories
{
	public class EnemyFactory
	{
        private readonly IRawContentManager rawContentManager;
        private readonly TextureManager textureManager;

        public EnemyFactory(IRawContentManager rawContentManager, TextureManager textureManager)
		{
            this.rawContentManager = rawContentManager;
            this.textureManager = textureManager;

            
        }


        public Enemy? GetEnemy(int enemyKey, Vector3 position)
		{
            EnemyDefinition? definition = this.rawContentManager.EnemyRepository.GetContent(enemyKey);

            if (definition != null)
            {
                Texture? texture = this.textureManager.GetTextureByKey(definition.TextureKey);
                EnemyBehaviour? behaviour = null;

                if (definition.EnemyType == EnemyTypes.BulletTurret) behaviour = new BulletTurretEnemyBehaviour();
                else if (definition.EnemyType == EnemyTypes.FireBallTurret) behaviour = new FireBallTurretEnemyBehaviour();
                else if (definition.EnemyType == EnemyTypes.ZombieMelee) behaviour = new ZombieMeleeEnemyBehaviour();
                else if (definition.EnemyType == EnemyTypes.RoamingSoldier) behaviour = new RoamingSoldierEnemyBehaviour();
                else if (definition.EnemyType == EnemyTypes.ExplosiveBarrel) behaviour = new ExplosiveBarrelBehaviour();
                else if (definition.EnemyType == EnemyTypes.FastMovingSlowAttackingMelee) behaviour = new ZombieMeleeEnemyBehaviour(90, 6);
                else if (definition.EnemyType == EnemyTypes.SlowMovingFastAttackingMelee) behaviour = new ZombieMeleeEnemyBehaviour(45, 3);
                else if (definition.EnemyType == EnemyTypes.FastMovingFastAttackingMelee) behaviour = new ZombieMeleeEnemyBehaviour(45, 6);
                else if (definition.EnemyType == EnemyTypes.SeekerLaser) behaviour = new SeekerLaserEnemyBehaviour(45, 3);
                else if (definition.EnemyType == EnemyTypes.SeekerRangedFireBall) behaviour = new SeekerRangedFireBallEnemyBehaviour();
                else if (definition.EnemyType == EnemyTypes.RoamingLaser) behaviour = new RoamingLaserEnemyBehaviour();
                else if (definition.EnemyType == EnemyTypes.SeekerMidRangedLightningBall) behaviour = new SeekerMidRangedLightningBallEnemyBehaviour();
                else if (definition.EnemyType == EnemyTypes.MagicBallTurret) behaviour = new MagicBallTurretEnemyBehaviour();
                else if (definition.EnemyType == EnemyTypes.BigBoss) behaviour = new BigBossEnemyBehaviour();
                else behaviour = new PassiveEnemyBehaviour();
                //TODO: Add More enemy types

                if (texture != null && behaviour != null)
                {
                    Enemy enemy = new Enemy(definition, texture, position, behaviour);

                    return enemy;
                }
            }

            return null;
		}



    }
}

