﻿using System;
using FirstPersonShooter.Models;
using RawResources;
using RawResources.Models;
using RawResources.Models.Items;

namespace FirstPersonShooter.Factories
{
	public class PlayerFactory
	{
        private readonly IRawContentManager rawContentManager;
        private readonly AmmoTypeFactory ammoTypeFactory;
        private readonly WeaponFactory weaponFactory;


        public PlayerFactory(IRawContentManager rawContentManager, AmmoTypeFactory ammoTypeFactory, WeaponFactory weaponFactory)
		{
            this.rawContentManager = rawContentManager;
            this.ammoTypeFactory = ammoTypeFactory;
            this.weaponFactory = weaponFactory;
        }


        public Player? GetPlayer()
        {
            PlayerDefinition? playerDefinition = this.rawContentManager.PlayerRepository.GetContent(0);
            if (playerDefinition == null) return null;

            Player player = new Player();
            player.HealthStats.SetAll(playerDefinition.StartHealth, playerDefinition.MaxHealth, playerDefinition.StartArmor, playerDefinition.MaxArmor);

            //starting ammo
            IEnumerable<AmmoTypeDefinition> ammoTypeDefinitions = this.rawContentManager.AmmoTypeRepository.GetAllContent();
            foreach(AmmoTypeDefinition ammoTypeDefinition in ammoTypeDefinitions)
            {
                AmmoType? ammoType = this.ammoTypeFactory.GetAmmoType(ammoTypeDefinition.Key);

                if(ammoType != null)
                {
                    player.Inventory.AddAmmoType(ammoType, ammoTypeDefinition.StartingAmount);
                }
            }

            //starting weapon
            Weapon? startingWeapon = this.weaponFactory.GetWeapon(playerDefinition.StartWeaponKey);
            if (startingWeapon != null)
            {
                player.Inventory.AddWeapon(startingWeapon);

                player.ActiveWeapon = startingWeapon;
            }

            return player;
        }


        public int GetStartingLevel()
        {
            PlayerDefinition? playerDefinition = this.rawContentManager.PlayerRepository.GetContent(0);
            if (playerDefinition == null) return -1;

            return playerDefinition.StartMapKey;
        }


	}
}

