﻿using System;
using FirstPersonShooter.Models;
using GameEngine;
using GameEngine.Audio;
using GameEngine.Graphics;
using RawResources;
using RawResources.Models.Items;

namespace FirstPersonShooter.Factories
{
	public class WeaponFactory
	{
        private readonly AudioDevice audioDevice;
        private readonly IRawContentManager rawContentManager;
        private readonly TextureManager textureManager;
        private readonly SoundManager soundManager;

        public WeaponFactory(AudioDevice audioDevice, IRawContentManager rawContentManager, TextureManager textureManager, SoundManager soundManager)
        {
            this.audioDevice = audioDevice;
            this.rawContentManager = rawContentManager;
            this.textureManager = textureManager;
            this.soundManager = soundManager;
        }


        public Weapon? GetWeapon(int key)
        {
            WeaponDefinition? definition = this.rawContentManager.WeaponRepository.GetContent(key);

            Texture? texture = null;
            if(definition != null) texture = this.textureManager.GetTextureByKey(definition.TextureKey);

            Texture? crosshairTexture = null;
            Texture? muzzleFlashTexture = null;
            Sound? shotSound = null;
            Sound? reloadSound = null;

            if (definition == null) return null;

            crosshairTexture = this.textureManager.GetTextureByKey(definition.CrosshairTextureKey);
            muzzleFlashTexture = this.textureManager.GetTextureByName("graphics/weapons/muzzleflash.png");
            shotSound = this.soundManager.GetSoundByKey(definition.SoundKey);
            reloadSound = this.soundManager.GetSoundByName("sounds/Gun-Reload.wav");

            Weapon weapon = new Weapon(this.audioDevice, definition, texture, muzzleFlashTexture, crosshairTexture, shotSound, reloadSound);
            weapon.CurrentAmmo = weapon.AmmoPerClip;

            return weapon;
        }


    }
}

