﻿using FirstPersonShooter.Models;
using GameEngine.Audio;

namespace FirstPersonShooter.Logic
{
	public class TeleportActivator
	{
        private readonly MyGame game;
        private readonly GameState gameState;


        public TeleportActivator(MyGame game, GameState gameState)
        {
            this.game = game;
            this.gameState = gameState;
        }


        public void CheckForAndUseTeleporter(Player player, Cube searchArea)
        {
            if (this.gameState.ActiveLevel == null) return;

            Level level = this.gameState.ActiveLevel;

            foreach(Teleporter teleporter in level.Teleporters)
            {
                if(teleporter.Cube.Intersects(searchArea))
                {
                    if(teleporter.IsVictory)
                    {
                        player.IsVictorious = true;
                    }
                    else if(teleporter.TargetLevelKey == level.Key)
                    {
                        player.Position = teleporter.TargetPosition;

                        //Play Teleportation Sound
                        Sound? sound = this.game.SoundManager.GetSoundByName("sounds/teleport.wav");
                        if (sound != null) sound.Play();
                    }
                    else
                    {
                        LevelChanger levelChanger = new LevelChanger(this.game, this.gameState);
                        levelChanger.ChangeToLevel(teleporter.TargetLevelKey, teleporter.TargetPosition);
                    }

                    return;
                }
            }
        }


    }
}

