﻿using FirstPersonShooter.Logic;
using GameEngine.Graphics.Models;

namespace FirstPersonShooter.Models
{
    public enum DoorStates { Closed, Open, Opening, Closing };

    public class Door : ICollisionObject
	{
        public Cube OriginalCube { get; set; }
        public IList<Quad> Quads { get; set; }
        public float Height { get; set; }

        public DoorStates DoorState { get; set; }
        public bool RequiresBlueKey { get; set; }
        public bool RequiresRedKey { get; set; }
        public bool RequiresGreenKey { get; set; }

        private float incrementalHeight;
        private int ticks;


        public Door()
        {
            this.OriginalCube = new Cube();
            this.Quads = new List<Quad>();

            this.RequiresBlueKey = false;
            this.RequiresGreenKey = false;
            this.RequiresRedKey = false;
            this.DoorState = DoorStates.Closed;

            this.Height = 0;
            this.ticks = 0;
            this.incrementalHeight = 0;
        }


        public void Update()
        {
            if (this.DoorState == DoorStates.Open)
            {
                this.ticks++;

                if(ticks >= 600)
                {
                    this.DoorState = DoorStates.Closing;
                    this.ticks = 0;
                }
            }
            else if (this.DoorState == DoorStates.Closed)
            {
                //nothing to do
            }
            else if (this.DoorState == DoorStates.Closing)
            {
                int maxTicksInState = 60;
                float dh = this.Height / maxTicksInState;

                this.incrementalHeight += dh;
                foreach(Quad quad in this.Quads)
                {
                    quad.AddHeight(dh);
                }

                ticks++;
                if(ticks > maxTicksInState)
                {
                    this.DoorState = DoorStates.Closed;
                    this.ticks = 0;
                }
            }
            else if (this.DoorState == DoorStates.Opening)
            {
                int maxTicksInState = 60;
                float dh = this.Height / maxTicksInState;

                this.incrementalHeight += -dh;
                foreach (Quad quad in this.Quads)
                {
                    quad.AddHeight(-dh);
                }

                ticks++;
                if (ticks > maxTicksInState)
                {
                    this.DoorState = DoorStates.Open;
                    this.ticks = 0;
                }
            }
        }


        public void Activate()
        {
            if(this.DoorState == DoorStates.Closed)
            {
                this.DoorState = DoorStates.Opening;
                this.ticks = 0;
            }
        }


        public Cube GetCollisionCube()
        {
            Cube currentCube = this.OriginalCube.AddHeight(incrementalHeight);

            return currentCube;
        }



    }
}

