﻿using System;
namespace FirstPersonShooter.Models
{
	public class Inventory
	{
		public IDictionary<int, Weapon> Weapons { get; private set; }
		public IDictionary<int, AmmoType> AmmoBag { get; private set; }
		public bool HasBlueKey { get; set; }
		public bool HasRedKey { get; set; }
		public bool HasGreenKey { get; set; }

		public Inventory()
		{
			this.Weapons = new Dictionary<int, Weapon>();
			this.AmmoBag = new Dictionary<int, AmmoType>();
			this.HasBlueKey = false;
			this.HasGreenKey = false;
			this.HasRedKey = false;
		}


		public void AddWeapon(Weapon weapon)
		{
			if(this.Weapons.ContainsKey(weapon.InventorySlot) == false)
			{
				this.Weapons.Add(weapon.InventorySlot, weapon);
			}
		}


		public void AddAmmoType(AmmoType ammoType, int amount)
		{
			if (this.AmmoBag.ContainsKey(ammoType.Key) == false)
			{
				this.AmmoBag.Add(ammoType.Key, ammoType);

                this.AmmoBag[ammoType.Key].Amount = amount;
            }
		}


		public bool IsAmmoAtMax(int ammoTypeKey)
		{
			if(this.AmmoBag.ContainsKey(ammoTypeKey))
			{
                AmmoType ammoType = this.AmmoBag[ammoTypeKey];

				if(ammoType.Amount == ammoType.MaxAmount)
				{
					return true;
				}
            }

			return false;
		}


		public void AddAmmo(int ammoTypeKey, int amount)
		{
			if (this.AmmoBag.ContainsKey(ammoTypeKey))
			{
				AmmoType ammoType = this.AmmoBag[ammoTypeKey];

                ammoType.Amount += amount;

				if (ammoType.Amount > ammoType.MaxAmount) ammoType.Amount = ammoType.MaxAmount;
			}
		}


		public int GetAmmo(int ammoTypeKey)
		{
			if (this.AmmoBag.ContainsKey(ammoTypeKey) == false) return 0;

			return this.AmmoBag[ammoTypeKey].Amount;
		}


		public Weapon? GetWeaponByKey(int weaponKey)
		{
			foreach(Weapon weapon in this.Weapons.Values)
			{
				if(weapon.Key == weaponKey)
				{
					return weapon;
				}
			}

			return null;
		}


		public bool HasWeaponInSlot(int slot)
		{
			return this.Weapons.ContainsKey(slot);
		}


		public int GetInventoryCount()
		{
			int count = 0;

			count += GetWeaponCount();
            count += GetKeyCount();

            return count;
		}


		public int GetWeaponCount()
		{
			return this.Weapons.Count;
        }


		public int GetKeyCount()
		{
            int count = 0;

            if (this.HasBlueKey) count++;
            if (this.HasGreenKey) count++;
            if (this.HasRedKey) count++;

            return count;
        }


		public bool HasKeys()
		{
			return (this.HasBlueKey || this.HasRedKey || this.HasGreenKey);
		}


		public int GetNextWeapon(int currentSlot)
		{
			List<int> slots = this.Weapons.Keys.ToList();

			if (slots.Count == 0) return -1;

			slots.Sort();

			int newSlot = slots[0];
			foreach(int slot in slots)
			{
				if(slot > currentSlot)
				{
					newSlot = slot;
					break;
				}
			}

			return newSlot;
        }


        public int GetPreviousWeapon(int currentSlot)
        {
            List<int> slots = this.Weapons.Keys.ToList();

            if (slots.Count == 0) return -1;

            slots.Sort();

            int newSlot = slots[slots.Count - 1];
            foreach (int slot in slots)
            {
                if (slot < currentSlot)
                {
                    newSlot = slot;
                }
            }

            return newSlot;
        }


    }
}

