﻿using System.Numerics;
using FirstPersonShooter.Logic;

namespace FirstPersonShooter.Models
{
	public class TextPoint: ICollisionObject
    {
        public Vector3 Position { get; private set; }
        public string Text { get; private set; }


        public TextPoint(Vector3 position, string text)
		{
			this.Position = position;
			this.Text = AdjustTextToFit(text);
		}


		public Cube GetCollisionCube()
		{
            return GetCollisionCubeAtPosition(this.Position);
        }


        public Cube GetCollisionCubeAtPosition(Vector3 point)
        {
            float halfWidth = 16;

            Vector3 p1 = new Vector3(point.X - halfWidth, point.Y - halfWidth, point.Z);
            Vector3 p2 = new Vector3(point.X + halfWidth, point.Y + halfWidth, point.Z);

            return new Cube(p1, p2);
        }


        private string AdjustTextToFit(string raw)
        {
            string t = "";

            int c = 0;
            for(int i = 0; i < raw.Length; i++)
            {
                t += raw[i];

                if (raw[i] != '\n')
                {
                    c++;
                }
                else
                {
                    c = 0;
                }
                

                if(c == 25)
                {
                    t += "\n";
                    c = 0;
                }
            }

            return t;
        }


    }
}

